/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallbackList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.requesttrack.ILongRunningRequestCallback;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTrackerSettings;
import com.helger.xservlet.requesttrack.TrackedRequest;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RequestTrackingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestTrackingManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bParallelRunningRequestsAboveLimit = false;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedMap<String, TrackedRequest> m_aOpenRequests = new CommonsLinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope, @Nonnull CallbackList<IParallelRunningRequestCallback> callbackList) {
        TrackedRequest trackedRequest;
        boolean bl = false;
        ICommonsList iCommonsList = null;
        this.m_aRWLock.writeLock().lock();
        try {
            trackedRequest = new TrackedRequest(string, iRequestWebScope);
            TrackedRequest trackedRequest2 = (TrackedRequest)this.m_aOpenRequests.put((Object)string, (Object)trackedRequest);
            if (trackedRequest2 != null && trackedRequest2.getRequestScope() != iRequestWebScope) {
                LOGGER.error("Request ID '" + string + "' is already registered! Old TR: " + trackedRequest2 + "; New TR: " + trackedRequest);
            }
            if (RequestTrackerSettings.isParallelRunningRequestsCheckEnabled() && this.m_aOpenRequests.size() >= RequestTrackerSettings.getParallelRunningRequestBarrier()) {
                bl = true;
                iCommonsList = this.m_aOpenRequests.copyOfValues();
                this.m_bParallelRunningRequestsAboveLimit = true;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (bl) {
            trackedRequest = iCommonsList;
            callbackList.forEach(arg_0 -> RequestTrackingManager.lambda$addRequest$0((ICommonsList)trackedRequest, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(@Nonnull @Nonempty String string, @Nonnull CallbackList<IParallelRunningRequestCallback> callbackList) {
        boolean bl = false;
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aOpenRequests.remove((Object)string) == null) {
                LOGGER.error("Failed to remove internal request with ID '" + string + "'");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Removed request with ID '" + string + "'");
            }
            if (RequestTrackerSettings.isParallelRunningRequestsCheckEnabled() && this.m_bParallelRunningRequestsAboveLimit && this.m_aOpenRequests.size() < RequestTrackerSettings.getParallelRunningRequestBarrier()) {
                this.m_bParallelRunningRequestsAboveLimit = false;
                bl = true;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (bl) {
            callbackList.forEach(IParallelRunningRequestCallback::onParallelRunningRequestsBelowLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForLongRunningRequests(@Nonnull ICallbackList<ILongRunningRequestCallback> iCallbackList) {
        if (iCallbackList.isNotEmpty()) {
            this.m_aRWLock.readLock().lock();
            try {
                if (RequestTrackerSettings.isLongRunningRequestsCheckEnabled()) {
                    Map.Entry entry;
                    long l;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Checking for long running requests");
                    }
                    long l2 = RequestTrackerSettings.getLongRunningRequestWarnDurationMillis();
                    Iterator iterator = this.m_aOpenRequests.entrySet().iterator();
                    while (iterator.hasNext() && (l = ((TrackedRequest)(entry = (Map.Entry)iterator.next()).getValue()).getRunningMilliseconds()) > l2) {
                        iCallbackList.forEach(iLongRunningRequestCallback -> iLongRunningRequestCallback.onLongRunningRequest((String)entry.getKey(), ((TrackedRequest)entry.getValue()).getRequestScope(), l));
                    }
                }
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
        }
    }

    private static /* synthetic */ void lambda$addRequest$0(ICommonsList iCommonsList, IParallelRunningRequestCallback iParallelRunningRequestCallback) {
        iParallelRunningRequestCallback.onParallelRunningRequests(iCommonsList.size(), (List<TrackedRequest>)iCommonsList);
    }
}

