/**
 * Copyright 2016-2019 Cloudera, Inc.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
package com.hortonworks.registries.schemaregistry;

/**
 * Validation level of the given schema
 */
public enum SchemaValidationLevel {

    /**
     * Validate schema only with the latest enabled versions
     */
    LATEST,

    /**
     * Validate schema with all enabled versions
     */
    ALL;
    
    public static final SchemaValidationLevel DEFAULT_VALIDATION_LEVEL = SchemaValidationLevel.ALL;
}
