/*
 * Copyright 2016-2019 Cloudera, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hortonworks.registries.schemaregistry.avro;

import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.SchemaValidator;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class ForwardCompatibilityValidator<T> implements SchemaCompatibilityValidator<T> {

    private final SchemaValidator<T> schemaValidator;

    public ForwardCompatibilityValidator(SchemaValidator<T> schemaValidator) {
        this.schemaValidator = schemaValidator;
    }

    @Override
    public CompatibilityResult validate(T toSchema, T existingSchema) {
        return schemaValidator.validate(existingSchema, toSchema);
    }
}
