/*
 * (c) Copyright 2008 Hewlett-Packard Development Company, LP
 * All rights reserved.
 * [See end of file]
 */

package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;

public class QueryIterPeek extends QueryIter1
{
    private Binding binding = null ; 
    private boolean closed = false ;
    
    public static QueryIterPeek create(QueryIterator iterator, ExecutionContext cxt)
    {
        if ( iterator instanceof QueryIterPeek)
            return (QueryIterPeek)iterator ;
        return new QueryIterPeek(iterator, cxt) ;
    }
    
    private QueryIterPeek(QueryIterator iterator, ExecutionContext cxt)
    {
        super(iterator, cxt) ;
    }

    public Binding peek() 
    {
        if ( closed ) return null ;
        if ( ! hasNextBinding() )
            return null ;
        return binding ;
    }

    protected boolean hasNextBinding()
    {
        if ( binding != null )
            return true ;
        if ( ! getInput().hasNext() )
            return false ;
        binding = getInput().nextBinding() ;
        return true ;
    }

    protected Binding moveToNextBinding()
    {
        if ( ! hasNextBinding() )
            throw new ARQInternalErrorException("No next binding") ;
        Binding b = binding ;
        binding = null ;
        return b ;
    }

    protected void closeSubIterator()
    { closed = true ; }
}

/*
 * (c) Copyright 2008 Hewlett-Packard Development Company, LP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */