/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Stack;

public class AlgebraQuad
extends TransformCopy {
    private AlgebraQuad() {
    }

    public static Op quadize(Op op) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(Quad.defaultGraphNode);
        Pusher before = new Pusher(stack);
        Popper after = new Popper(stack);
        TransformQuadGraph qg = new TransformQuadGraph(stack);
        return Transformer.transform(qg, op, before, after);
    }

    private static class TransformQuadGraph
    extends TransformCopy {
        private Stack tracker;

        public TransformQuadGraph(Stack tracker) {
            this.tracker = tracker;
        }

        private Node getNode() {
            return (Node)this.tracker.peek();
        }

        public Op transform(OpGraph opGraph, Op op) {
            boolean noPattern = false;
            if (OpBGP.isBGP(op)) {
                if (((OpBGP)op).getPattern().isEmpty()) {
                    noPattern = true;
                }
            } else if (op instanceof OpTable && ((OpTable)op).isJoinIdentity()) {
                noPattern = true;
            }
            if (noPattern) {
                return new OpDatasetNames(opGraph.getNode());
            }
            return op;
        }

        public Op transform(OpPath opPath) {
            return new OpGraph(this.getNode(), opPath);
        }

        public Op transform(OpBGP opBGP) {
            return new OpQuadPattern(this.getNode(), opBGP.getPattern());
        }
    }

    private static class Popper
    extends OpVisitorBase {
        Stack stack;

        Popper(Stack stack) {
            this.stack = stack;
        }

        public void visit(OpGraph opGraph) {
            Node n = (Node)this.stack.pop();
        }
    }

    private static class Pusher
    extends OpVisitorBase {
        Stack stack;

        Pusher(Stack stack) {
            this.stack = stack;
        }

        public void visit(OpGraph opGraph) {
            this.stack.push(opGraph.getNode());
        }
    }
}

