/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BasicPattern {
    private List triples;

    public BasicPattern() {
        this(new ArrayList());
    }

    public BasicPattern(BasicPattern other) {
        this();
        this.triples.addAll(other.triples);
    }

    private BasicPattern(List triples) {
        this.triples = triples;
    }

    public static BasicPattern wrap(List triples) {
        return new BasicPattern(triples);
    }

    public void add(Triple t) {
        this.triples.add(t);
    }

    public void addAll(BasicPattern other) {
        this.triples.addAll(other.triples);
    }

    public void add(int i, Triple t) {
        this.triples.add(i, t);
    }

    public Triple get(int i) {
        return (Triple)this.triples.get(i);
    }

    public ListIterator iterator() {
        return this.triples.listIterator();
    }

    public int size() {
        return this.triples.size();
    }

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public List getList() {
        return this.triples;
    }

    public int hashCode() {
        return ((Object)this.triples).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicPattern)) {
            return false;
        }
        BasicPattern bp = (BasicPattern)other;
        return ((Object)this.triples).equals(bp.triples);
    }

    public boolean equiv(BasicPattern other, NodeIsomorphismMap isoMap) {
        if (this.triples.size() != other.triples.size()) {
            return false;
        }
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple t2;
            Triple t1 = this.get(i);
            if (Utils.tripleIso(t1, t2 = other.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        IndentedWriter out = buff.getIndentedWriter();
        SerializationContext sCxt = SSE.sCxt(SSE.defaultPrefixMapWrite);
        boolean first = true;
        Iterator iter = this.triples.iterator();
        while (iter.hasNext()) {
            if (!first) {
                out.print(" ");
            } else {
                first = false;
            }
            Triple t = (Triple)iter.next();
            out.print("(");
            WriterNode.outputPlain(out, t, sCxt);
            out.print(")");
        }
        out.flush();
        return buff.getBuffer().toString();
    }
}

