/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggCountVar
implements AggregateFactory {
    private Var var;

    public AggCountVar(Var var) {
        this.var = var;
    }

    public Aggregator create() {
        return new AggCountVarWorker();
    }

    private class AccCountVar
    implements Accumulator {
        private long count = 0L;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            if (binding.contains(AggCountVar.this.var)) {
                ++this.count;
            }
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }

    private class AggCountVarWorker
    extends AggregatorBase {
        public String toString() {
            return "count(" + (Object)((Object)AggCountVar.this.var) + ")";
        }

        public String toPrefixString() {
            return "(count " + (Object)((Object)AggCountVar.this.var) + ")";
        }

        protected Accumulator createAccumulator() {
            return new AccCountVar();
        }

        public Node getValueEmpty() {
            return NodeValue.nodeIntZERO;
        }
    }
}

