/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.sparql.path.P_Alt;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_Reverse;
import com.hp.hpl.jena.sparql.path.P_Seq;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathVisitor;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathEval {
    private static Log log = LogFactory.getLog((Class)PathEval.class);

    public static NodeIterator walkForwards(final Model model, RDFNode rdfNode, Path path) {
        Iterator iter = PathEval.eval(model.getGraph(), rdfNode.asNode(), path);
        Map1 conv = new Map1(){

            public Object map1(Object obj) {
                return ModelUtils.convertGraphNodeToRDFNode((Node)obj, model);
            }
        };
        return new NodeIteratorImpl((Iterator)new Map1Iterator(conv, iter), null);
    }

    public static NodeIterator walkBackwards(final Model model, RDFNode rdfNode, Path path) {
        Iterator iter = PathEval.evalReverse(model.getGraph(), rdfNode.asNode(), path);
        Map1 conv = new Map1(){

            public Object map1(Object obj) {
                return ModelUtils.convertGraphNodeToRDFNode((Node)obj, model);
            }
        };
        return new NodeIteratorImpl((Iterator)new Map1Iterator(conv, iter), null);
    }

    public static Iterator eval(Graph graph, Node node, Path path) {
        if (node == null) {
            ALog.fatal(PathEval.class, "PathEval.eval applied to a null node");
        }
        if (node.isVariable()) {
            ALog.warn(PathEval.class, "PathEval.eval applied to a variable: " + node);
        }
        return PathEval.eval(graph, node, path, true);
    }

    public static Iterator evalReverse(Graph g, Node node, Path path) {
        return PathEval.eval(g, node, path, false);
    }

    private static Iterator eval(Graph graph, Node node, Path path, boolean forward) {
        LinkedHashSet acc = new LinkedHashSet();
        PathEval.eval(graph, node, path, forward, acc);
        return acc.iterator();
    }

    private static Iterator eval(Graph graph, Iterator input, Path path, boolean forward) {
        LinkedHashSet acc = new LinkedHashSet();
        while (input.hasNext()) {
            Node node = (Node)input.next();
            PathEval.eval(graph, node, path, forward, acc);
        }
        return acc.iterator();
    }

    private static void eval(Graph graph, Node node, Path p, boolean forward, Collection acc) {
        PathEvaluator evaluator = new PathEvaluator(graph, node, acc, forward);
        p.visit(evaluator);
    }

    private static class PathEvaluator
    implements PathVisitor {
        private final Graph graph;
        private final Node node;
        private final Collection output;
        private boolean forwardMode;
        private static Map1 selectObject = new Map1(){

            public Object map1(Object triple) {
                return ((Triple)triple).getObject();
            }
        };
        private static Map1 selectSubject = new Map1(){

            public Object map1(Object triple) {
                return ((Triple)triple).getSubject();
            }
        };

        public PathEvaluator(Graph g, Node n, Collection output, boolean forward) {
            this.graph = g;
            this.node = n;
            this.output = output;
            this.forwardMode = forward;
        }

        public void visit(P_Link pathNode) {
            Iterator nodes = this.doOne(pathNode.getNode());
            this.fill(nodes);
        }

        public void visit(P_Reverse reversePath) {
            this.forwardMode = !this.forwardMode;
            reversePath.getSubPath().visit(this);
            this.forwardMode = !this.forwardMode;
        }

        public void visit(P_Alt pathAlt) {
            Iterator iter = PathEval.eval(this.graph, this.node, pathAlt.getLeft(), this.forwardMode);
            this.fill(iter);
            iter = PathEval.eval(this.graph, this.node, pathAlt.getRight(), this.forwardMode);
            this.fill(iter);
        }

        public void visit(P_Seq pathSeq) {
            Path part1 = this.forwardMode ? pathSeq.getLeft() : pathSeq.getRight();
            Path part2 = this.forwardMode ? pathSeq.getRight() : pathSeq.getLeft();
            Iterator iter = PathEval.eval(this.graph, this.node, part1, this.forwardMode);
            iter = PathEval.eval(this.graph, iter, part2, this.forwardMode);
            this.fill(iter);
        }

        public void visit(P_Mod pathMod) {
            if (pathMod.isZeroOrMore()) {
                this.doZeroOrMore(pathMod.getSubPath());
                return;
            }
            if (pathMod.isOneOrMore()) {
                this.doOneOrMore(pathMod.getSubPath());
                return;
            }
            if (pathMod.getMin() == 0L) {
                this.output.add(this.node);
            }
            if (pathMod.getMax() == 0L) {
                return;
            }
            Iterator iter = PathEval.eval(this.graph, this.node, pathMod.getSubPath(), this.forwardMode);
            long min2 = PathEvaluator.dec(pathMod.getMin());
            long max2 = PathEvaluator.dec(pathMod.getMax());
            P_Mod nextPath = new P_Mod(pathMod.getSubPath(), min2, max2);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                Iterator iter2 = PathEval.eval(this.graph, n2, nextPath, this.forwardMode);
                this.fill(iter2);
            }
        }

        private void fill(Iterator iter) {
            while (iter.hasNext()) {
                this.output.add(iter.next());
            }
        }

        private final Iterator doOne(Node property) {
            Map1Iterator iter2 = null;
            if (this.forwardMode) {
                ExtendedIterator iter1 = this.graph.find(this.node, property, Node.ANY);
                iter2 = new Map1Iterator(selectObject, (Iterator)iter1);
            } else {
                ExtendedIterator iter1 = this.graph.find(Node.ANY, property, this.node);
                iter2 = new Map1Iterator(selectSubject, (Iterator)iter1);
            }
            return iter2;
        }

        private static long dec(long x) {
            return x <= 0L ? x : x - 1L;
        }

        private void doOneOrMore(Path path) {
            Iterator iter1 = PathEval.eval(this.graph, this.node, path, this.forwardMode);
            LinkedHashSet visited = new LinkedHashSet();
            while (iter1.hasNext()) {
                Node n1 = (Node)iter1.next();
                PathEvaluator.closure(this.graph, n1, path, visited, this.forwardMode);
            }
            this.output.addAll(visited);
        }

        private void doZeroOrMore(Path path) {
            LinkedHashSet visited = new LinkedHashSet();
            PathEvaluator.closure(this.graph, this.node, path, visited, this.forwardMode);
            this.output.addAll(visited);
        }

        private static void closure(Graph graph, Node node, Path path, Collection visited, boolean forward) {
            if (visited.contains(node)) {
                return;
            }
            visited.add(node);
            Iterator iter = PathEval.eval(graph, node, path, forward);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                PathEvaluator.closure(graph, n2, path, visited, forward);
            }
        }
    }
}

