/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.sparql.util.RomanNumeral;

public class RomanNumeralDatatype
extends BaseDatatype {
    private static boolean firstClassDatatype = false;
    private static RomanNumeralDatatype datatype = new RomanNumeralDatatype();
    private static final String URI = "http://rome.example.org/Numeral";

    public static void enableAsFirstClassDatatype() {
        if (!firstClassDatatype) {
            TypeMapper.getInstance().registerDatatype((RDFDatatype)RomanNumeralDatatype.get());
        }
    }

    public static RomanNumeralDatatype get() {
        return datatype;
    }

    private RomanNumeralDatatype() {
        super(URI);
    }

    public Class getJavaClass() {
        return RomanNumeral.class;
    }

    public String unparse(Object value) {
        return value.toString();
    }

    public Object parse(String lexicalForm) throws DatatypeFormatException {
        try {
            return new Integer(RomanNumeral.r2i(lexicalForm));
        }
        catch (NumberFormatException ex) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)this, ex.getMessage());
        }
    }

    public String toString() {
        return "Roman Numeral";
    }
}

