/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSmartLobOutputStream;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxBblob
extends IfxLob
implements Blob {
    public IfxBblob() {
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxLocator locator) {
        this.locatorPointer = locator;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    public IfxBblob(IfxConnection connection, IfxLocator locator) throws SQLException {
        this.conn = connection;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
        this.smb = new IfxSmartBlob(connection);
        this.smb.IfxLoOpen(locator, connection.getLOMode());
    }

    public IfxBblob(IfxConnection connection) throws SQLException {
        super(connection);
        this.ifxType = (short)2;
    }

    protected IfxBblob(byte[] buffer) {
        this.blobBuffer = buffer;
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(InputStream fin) {
        this.blobStream = fin;
        this.ifxType = (short)2;
        this.smartBlobMode = 2;
    }

    protected IfxBblob(IfxTmpFile tempFile) {
        this.tempBlobFile = tempFile;
        this.tempBlobFile.incRefCount();
        this.ifxType = (short)2;
        this.smartBlobMode = 0;
    }

    public IfxBblob(Connection conn, InputStream fin, int length) throws SQLException {
        super(conn, fin, length);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection conn, InputStream fin, int length, String sbspaceName) throws SQLException {
        super(conn, fin, length, sbspaceName);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection conn, InputStream fin, int length, IfxLobDescriptor loDesc) throws SQLException {
        super(conn, fin, length, loDesc);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection conn, byte[] buffer) throws SQLException {
        super(conn, buffer);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection conn, byte[] buffer, String sbspaceName) throws SQLException {
        super(conn, buffer, sbspaceName);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    public IfxBblob(Connection conn, byte[] buffer, IfxLobDescriptor loDesc) throws SQLException {
        super(conn, buffer, loDesc);
        this.ifxType = (short)2;
        this.smartBlobMode = 1;
    }

    @Override
    public long length() throws SQLException {
        this.checkIfFreed();
        return this.blobSize;
    }

    @Override
    public byte[] getBytes(long position, int length) throws SQLException {
        this.checkIfFreed();
        return super.getPortion(position, length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getStream();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return super.getBinaryStream(pos, length);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkIfFreed();
        long mystart = start - 1L;
        byte[] b = super.getPortion(1L, this.blobSize);
        if (b == null) {
            return -1L;
        }
        String s = new String(b);
        long ret_val = s.indexOf(new String(pattern), (int)mystart);
        if (ret_val >= 0L) {
            ++ret_val;
        }
        return ret_val;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public void setBinaryStream(long position, InputStream fin, int length) throws SQLException {
        this.checkIfFreed();
        this.verifyBlob();
        this.smb.IfxLoSeek(this.smb.getHandle(), position, 0);
        super.setStream(fin, length);
    }

    @Override
    public int setBytes(long position, byte[] buffer) throws SQLException {
        return this.setBytes(position, buffer, 0, buffer == null ? 0 : buffer.length);
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    @Override
    public long seek(long offset, int whence) throws SQLException {
        return super.seek(offset, whence);
    }

    @Override
    public long where() throws SQLException {
        return super.where();
    }

    @Override
    public IfxLoStat getLoStat() throws SQLException {
        return super.getLoStat();
    }

    @Override
    public void truncate(long size) throws SQLException {
        super.truncate(size);
    }

    @Override
    public int setBytes(long position, byte[] bytes, int offset, int len) throws SQLException {
        this.checkIfFreed();
        this.verifyBlob();
        this.smb.IfxLoSeek(this.smb.getHandle(), position, 0);
        return super.setBuffer(bytes, offset, len);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkIfFreed();
        this.verifyBlob();
        return new IfxSmartLobOutputStream(this, pos);
    }

    private void verifyBlob() throws SQLException {
        if (this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        this.verifySmbMode();
    }

    @Override
    public void free() throws SQLException {
        super.free();
    }
}

