/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Version2 {
    private static final String BUILD_INFORMATION_FILE = "/META-INF/MANIFEST.MF";
    private static final int majorVersion;
    private static final int minorVersion;
    private static final int serviceVersion;
    private static final int serviceSubVersion;
    private static final Date buildDate;
    private static final int buildNumber;
    private static final String vendor;
    private static final int betaVersion;
    private static final String commit;
    private static final String supportVersion;

    public static void main(String[] args) {
        System.out.println(Version2.getVersionAsString());
    }

    public static String getVersionAsString() {
        StringBuilder sb = new StringBuilder("Product-Name: " + vendor + " Informix JDBC Driver\n");
        if (vendor != null) {
            sb.append("Product-Vendor: " + vendor + '\n');
        }
        sb.append("Build-Version: " + majorVersion + '.' + minorVersion + '.' + serviceVersion + '.' + serviceSubVersion + '\n');
        sb.append("Build-Number: " + buildNumber + '\n');
        sb.append("Build-Date: " + (buildDate == null ? "" : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(buildDate)) + '\n');
        if (betaVersion > 0) {
            sb.append("Beta-Version: " + betaVersion + '\n');
        }
        if (!supportVersion.isEmpty()) {
            sb.append("Support-Version: " + supportVersion + '\n');
        }
        if (!commit.isEmpty()) {
            sb.append("Commit: " + commit);
        }
        return sb.toString().trim();
    }

    public static int getMajorVersion() {
        return majorVersion;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    public static int getServiceVersion() {
        return serviceVersion;
    }

    public static int getServiceSubVersion() {
        return serviceSubVersion;
    }

    public static int getBuildNumber() {
        return buildNumber;
    }

    public static Date getBuildDate() {
        return buildDate;
    }

    public static String getVendor() {
        return vendor;
    }

    public static String getLegacyVersionString() {
        String toReturn = "" + majorVersion + '.' + minorVersion + ".JC" + serviceVersion;
        if (serviceSubVersion > 0) {
            toReturn = toReturn + "W" + serviceSubVersion;
        }
        if (betaVersion > 0) {
            toReturn = toReturn + "B" + betaVersion;
        }
        toReturn = toReturn + supportVersion;
        return toReturn;
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        int major = 4;
        int minor = 50;
        int service = 3;
        int subservice = 0;
        int build = 0;
        int beta = 0;
        Date date = null;
        String commitLine = "";
        String supportVersionId = "";
        Properties p = new Properties();
        URL url = Version2.class.getClassLoader().getResource("com/informix/jdbc/jdbc-version.properties");
        if (url != null) {
            try (InputStream is = Version2.class.getClassLoader().getResource("com/informix/jdbc/jdbc-version.properties").openStream();){
                String[] versionSplit;
                p.load(is);
                String version = p.getProperty("version", "-1.-1.-1");
                if (version.indexOf(45) > 0) {
                    version = version.substring(0, version.indexOf(45));
                }
                if ((versionSplit = version.split("\\.")).length != 3 && versionSplit.length != 4) {
                    throw new RuntimeException("Incorrect number of properties for build file:  /META-INF/MANIFEST.MF");
                }
                major = Integer.parseInt(versionSplit[0]);
                minor = Integer.parseInt(versionSplit[1]);
                service = Integer.parseInt(versionSplit[2]);
                if (versionSplit.length == 4) {
                    subservice = Integer.parseInt(versionSplit[3]);
                }
                date = dateFormat.parse(p.getProperty("build-date"));
                build = Integer.parseInt(p.getProperty("build-number", "0"));
                beta = Integer.parseInt(p.getProperty("beta-version", "0"));
                commitLine = p.getProperty("commit", "");
                supportVersionId = p.getProperty("support-version", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vendor = p.getProperty("vendor", "");
        majorVersion = major;
        minorVersion = minor;
        serviceVersion = service;
        buildDate = date;
        buildNumber = build;
        serviceSubVersion = subservice;
        betaVersion = beta;
        commit = commitLine;
        supportVersion = supportVersionId;
    }
}

