/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.JFAPCommunicator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ClientJFapCommunicator
extends JFAPCommunicator {
    private static final TraceComponent tc = SibTr.register(ClientJFapCommunicator.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private ClientConversationState cConState = null;
    private CommsByteBufferPool commsByteBufferPool = CommsByteBufferPool.getInstance();

    @Override
    protected int getConnectionObjectID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionObjectID");
        }
        int objectID = 0;
        this.validateConversationState();
        objectID = this.cConState.getConnectionObjectID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnectionObjectID", (Object)("" + objectID));
        }
        return objectID;
    }

    @Override
    protected void setConnectionObjectID(int i) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConnectionObjectID", (Object)("" + i));
        }
        this.validateConversationState();
        this.cConState.setConnectionObjectID(i);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConnectionObjectID");
        }
    }

    @Override
    protected CommsConnection getCommsConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCommsConnection");
        }
        CommsConnection cc = null;
        this.validateConversationState();
        cc = this.cConState.getCommsConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCommsConnection", (Object)cc);
        }
        return cc;
    }

    @Override
    protected void setCommsConnection(CommsConnection cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCommsConnection");
        }
        this.validateConversationState();
        this.cConState.setCommsConnection(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCommsConnection");
        }
    }

    protected void setSICoreConnection(SICoreConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSICoreConnection", (Object)connection);
        }
        this.validateConversationState();
        this.cConState.setSICoreConnection(connection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSICoreConnection");
        }
    }

    @Override
    protected void createConversationState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConversationState");
        }
        ClientConversationState ccs = new ClientConversationState();
        this.getConversation().setAttachment(ccs);
        ClientLinkLevelState clls = (ClientLinkLevelState)this.getConversation().getLinkLevelAttachment();
        if (clls == null) {
            this.getConversation().setLinkLevelAttachment(new ClientLinkLevelState());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConversationState");
        }
    }

    @Override
    protected int getRequestNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRequestNumber");
        }
        int reqnum = -1;
        this.validateConversationState();
        int initialRequestNumber = -1;
        while (reqnum < 0 || !this.getConversation().checkRequestNumberIsFree(reqnum)) {
            reqnum = this.cConState.getUniqueRequestNumber();
            if (initialRequestNumber == reqnum) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Request numbers wrapped");
                break;
            }
            if (initialRequestNumber >= 0) continue;
            initialRequestNumber = reqnum;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRequestNumber", (Object)("" + reqnum));
        }
        return reqnum;
    }

    @Override
    protected CommsByteBuffer getCommsByteBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCommsByteBuffer");
        }
        CommsByteBuffer buff = this.commsByteBufferPool.allocate();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCommsByteBuffer", (Object)buff);
        }
        return buff;
    }

    private void validateConversationState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateConversationState");
        }
        if (this.cConState == null) {
            this.cConState = (ClientConversationState)this.getConversation().getAttachment();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using Client Conversation State:", (Object)this.cConState);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateConversationState");
        }
    }

    @Override
    protected void initiateCommsHandshaking() throws SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initiateCommsHandshaking");
        }
        this.initiateCommsHandshakingImpl(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initiateCommsHandshaking");
        }
    }
}

