/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.List;

public abstract class ClientConnectionManager {
    private static final TraceComponent tc;
    private static boolean initialised;
    private static ClientConnectionManager instance;
    public static final String TCP_CHAIN = "BootstrapBasicMessaging";

    public static synchronized void initialise() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        if (!initialised) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"not previously initialised");
            }
            Class<?> clientImpl = instance.getClass();
            try {
                Method initialiseMethod = clientImpl.getMethod("initialise", new Class[0]);
                initialiseMethod.invoke(clientImpl, new Object[0]);
                initialised = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.ClientConnectionManager.initialise", (String)"00000002");
                SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICJ0002", (Object)new Object[]{"initialise", "com.ibm.ws.sib.jfapchannel.impl.ClientConnectionManagerImpl", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public static synchronized ClientConnectionManager getRef() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRef");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRef", (Object)instance);
        }
        return instance;
    }

    public abstract Conversation connect(InetSocketAddress var1, ConversationReceiveListener var2, String var3) throws SIResourceException;

    public abstract Conversation connect(Object var1, ConversationReceiveListener var2) throws SIResourceException;

    public abstract Conversation connect(ConversationReceiveListener var1, ConversationUsageType var2) throws SIResourceException;

    public abstract List getActiveOutboundConversations();

    public abstract List getActiveOutboundConversationsForFfdc();

    public abstract OutboundConnectionTracker getOutboundConnectionTracker();

    static {
        block5: {
            tc = SibTr.register(ClientConnectionManager.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client/src/com/ibm/ws/sib/jfapchannel/ClientConnectionManager.java, SIB.comms, WASX.SIB, uu1215.01 1.36");
            }
            initialised = false;
            instance = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"static <init>");
            }
            try {
                Class<?> clientImpl = Class.forName("com.ibm.ws.sib.jfapchannel.impl.ClientConnectionManagerImpl");
                Constructor<?> clientImplConstructor = clientImpl.getConstructor(new Class[0]);
                instance = (ClientConnectionManager)clientImplConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.ClientConnectionManager.{}", (String)"00000001");
                SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICJ0001", (Object)new Object[]{"com.ibm.ws.sib.jfapchannel.impl.ClientConnectionManagerImpl", e});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"static <init>");
        }
    }
}

