/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.ExchangeReceiveListenerPool;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ExchangeReceiveListener
implements ReceiveListener,
ReceivedData {
    private static final TraceComponent tc = SibTr.register(ExchangeReceiveListener.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final String $sccsid = "@(#) 1.28 SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ExchangeReceiveListener.java, SIB.comms, WASX.SIB, uu1215.01 08/05/28 21:41:42 [4/12/12 22:14:13]";
    private final ExchangeReceiveListenerPool pool;
    private int expectedRequestNumber;
    private WsByteBuffer data;
    private int segmentNumber;
    private int requestNumber;
    private int priority;
    private boolean canPool;
    private SIConnectionLostException exception = null;
    private boolean requestComplete = false;

    public ExchangeReceiveListener(ExchangeReceiveListenerPool pool) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)pool);
        }
        this.pool = pool;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected synchronized void setExpectedRequestNumber(int reqNum) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExpectedRequestNumber", (Object)("reqNum=" + reqNum));
        }
        this.expectedRequestNumber = reqNum;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExpectedRequestNumber");
        }
    }

    protected synchronized void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        this.data = null;
        this.exception = null;
        this.requestComplete = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    public synchronized void dataReceived(WsByteBuffer d, int segmentNumber, int requestNumber, int priority, boolean canPool, boolean partOfExchange, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived", (Object)new Object[]{d, "" + segmentNumber, "" + requestNumber, "" + priority, "" + canPool, "" + partOfExchange, conversation});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBuffer(this, tc, d, 32, "Exchange listener data received");
        }
        this.requestComplete = true;
        this.notify();
        if (requestNumber != this.expectedRequestNumber) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"detaReceived", (Object)"reqNum != expected");
            }
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"EXCHANGERL_INTERNAL_SICJ0049", null, (String)"EXCHANGERL_INTERNAL_SICJ0049"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("dataReceived:\ndata=");
            sb.append(this.data);
            sb.append("\nsegmentNumber=" + segmentNumber);
            sb.append("\nrequestNumber=" + requestNumber);
            sb.append("\npriority=" + priority);
            sb.append("\ncanPool=" + canPool);
            sb.append("\npartOfExchange=" + partOfExchange);
            SibTr.debug((Object)this, (TraceComponent)tc, (String)sb.toString());
        }
        this.data = d;
        this.segmentNumber = segmentNumber;
        this.requestNumber = requestNumber;
        this.priority = priority;
        this.canPool = canPool;
        this.exception = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
        }
    }

    @Override
    public synchronized void errorOccurred(SIConnectionLostException e, int segmentNumber, int requestNumber, int priority, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred", (Object)new Object[]{e, "" + segmentNumber, "" + requestNumber, "" + priority, conversation});
        }
        this.requestComplete = true;
        this.notify();
        if (requestNumber != this.expectedRequestNumber) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("requestNumber (" + requestNumber + ") != expectedRequestNumber (" + this.expectedRequestNumber + ")"));
            }
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"EXCHANGERL_INTERNAL_SICJ0049", null, (String)"EXCHANGERL_INTERNAL_SICJ0049"));
        }
        this.exception = e;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"errorOccurred");
        }
    }

    public synchronized boolean successful() {
        boolean rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"successful");
        }
        boolean bl = rc = this.exception == null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"successful", (Object)("rc=" + rc));
        }
        return rc;
    }

    public synchronized SIConnectionLostException getException() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getException");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && this.exception != null) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)this.exception));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getException", (Object)((Object)this.exception));
        }
        return this.exception;
    }

    public void closeReceived(boolean quiesce) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeReceived", (Object)("quiesce=" + quiesce));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeReceived");
        }
    }

    @Override
    public synchronized WsByteBuffer getBuffer() {
        return this.data;
    }

    @Override
    public synchronized int getSegmentType() {
        return this.segmentNumber;
    }

    @Override
    public synchronized int getRequestId() {
        return this.requestNumber;
    }

    @Override
    public synchronized int getPriority() {
        return this.priority;
    }

    @Override
    public synchronized boolean getAllocatedFromBufferPool() {
        return this.canPool;
    }

    protected synchronized void waitToComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitToComplete");
        }
        while (!this.requestComplete) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitToComplete");
        }
    }

    @Override
    public void release() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"release");
        }
        this.pool.release(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"release");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.28 SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ExchangeReceiveListener.java, SIB.comms, WASX.SIB, uu1215.01 08/05/28 21:41:42 [4/12/12 22:14:13]");
        }
    }
}

