/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionData;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionDataIterator;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;

public class PriorityQueue {
    private static final TraceComponent tc = SibTr.register(PriorityQueue.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final StateEnum OPEN = new StateEnum("OPEN");
    private static final StateEnum CLOSING = new StateEnum("CLOSING");
    private static final StateEnum CLOSED = new StateEnum("CLOSED");
    private StateEnum state = OPEN;
    private Conversation.ConversationType type = Conversation.UNKNOWN;
    private static volatile int clientQueuedBytes = 0;
    private static volatile int meQueuedBytes = 0;
    private static int maxQueueDepth = 100;
    private static int maxQueueBytes = 102400;
    private Queue[] queueArray = new Queue[16];
    private int lowestPriorityWithCapacity = 0;
    private int totalQueueDepth = 0;
    public Object queueMonitor;
    private ActivatableMonitor closeWaitersMonitor = new ActivatableMonitor(true);

    public PriorityQueue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        for (int i = 0; i < 16; ++i) {
            this.queueArray[i] = new Queue();
        }
        this.queueMonitor = this;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void queue(JFapByteBuffer bufferData, int segmentType, int requestNumber, int priority, SendListener sendListener, Conversation conversation, Connection connection, int conversationId, boolean pooledBuffers, boolean partOfExchange, long size, boolean terminal, Conversation.ThrottlingPolicy throttlingPolicy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"queue");
        }
        TransmissionDataIterator iterator = TransmissionDataIterator.allocateFromPool(connection, bufferData, priority, pooledBuffers, partOfExchange, segmentType, conversationId, requestNumber, conversation, sendListener, terminal, (int)size);
        if (this.type == Conversation.ME) {
            meQueuedBytes = (int)((long)meQueuedBytes + size);
        } else if (this.type == Conversation.CLIENT) {
            clientQueuedBytes = (int)((long)clientQueuedBytes + size);
        }
        this.queueInternal(iterator, throttlingPolicy, terminal);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInternal(TransmissionDataIterator data, Conversation.ThrottlingPolicy throttlingPolicy, boolean isTerminal) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"queueInternal", (Object)data);
        }
        boolean done = false;
        boolean releaseTransmission = false;
        int priority = data.getPriority();
        int size = data.getSize();
        CircularFIFOArrayBuffer queue = null;
        while (!done) {
            ActivatableMonitor monitor = null;
            Object object = this.queueMonitor;
            synchronized (object) {
                if (this.state == CLOSED) {
                    done = true;
                } else {
                    if (isTerminal) {
                        this.state = CLOSING;
                    }
                    if (queue == null) {
                        if (priority == -1) {
                            int max = 15;
                            for (priority = 0; priority < max && this.queueArray[priority].depth == 0; ++priority) {
                            }
                            data.setPriority(priority);
                            queue = this.queueArray[priority];
                        } else {
                            queue = this.queueArray[priority];
                        }
                    }
                    if (throttlingPolicy == Conversation.ThrottlingPolicy.DO_NOT_THROTTLE || ((Queue)queue).hasCapacity && priority >= this.lowestPriorityWithCapacity) {
                        queue.enqueue(data);
                        ((Queue)queue).bytes += data.getSize();
                        ++((Queue)queue).depth;
                        ++this.totalQueueDepth;
                        done = true;
                        if (((Queue)queue).hasCapacity && (((Queue)queue).depth >= maxQueueDepth || ((Queue)queue).bytes >= maxQueueBytes)) {
                            ((Queue)queue).hasCapacity = false;
                            if (priority >= this.lowestPriorityWithCapacity) {
                                int newLowestPriorityWithCapacity = priority + 1;
                                while (this.lowestPriorityWithCapacity < newLowestPriorityWithCapacity) {
                                    this.queueArray[this.lowestPriorityWithCapacity].monitor.setActive(true);
                                    ++this.lowestPriorityWithCapacity;
                                }
                            }
                        }
                    } else if (throttlingPolicy == Conversation.ThrottlingPolicy.BLOCK_THREAD) {
                        monitor = ((Queue)queue).monitor;
                    } else if (throttlingPolicy == Conversation.ThrottlingPolicy.DISCARD_TRANSMISSION) {
                        releaseTransmission = true;
                        done = true;
                    }
                }
            }
            if (monitor == null) continue;
            monitor.waitOn();
        }
        if (releaseTransmission) {
            data.release();
        }
        if (this.type == Conversation.CLIENT) {
            clientQueuedBytes += size;
        } else {
            meQueuedBytes += size;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queueInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionData dequeue() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dequeue");
        }
        TransmissionData retValue = null;
        Queue queue = null;
        Object object = this.queueMonitor;
        synchronized (object) {
            int priority;
            if (this.state == CLOSED) {
                throw new SIConnectionDroppedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"PRIORITY_QUEUE_PURGED_SICJ0077", null, (String)"PRIORITY_QUEUE_PURGED_SICJ0077"));
            }
            for (priority = 15; priority >= 0 && this.queueArray[priority].depth == 0; --priority) {
            }
            if (priority >= 0) {
                queue = this.queueArray[priority];
                TransmissionDataIterator iterator = queue.head();
                retValue = iterator.next();
                queue.bytes -= retValue.getSize();
                if (!iterator.hasNext()) {
                    queue.dequeue();
                    --queue.depth;
                    --this.totalQueueDepth;
                }
                if (this.totalQueueDepth == 0 && this.state == CLOSING) {
                    this.state = CLOSED;
                    this.closeWaitersMonitor.setActive(false);
                    for (int i = 0; i < 16; ++i) {
                        this.queueArray[i].monitor.setActive(false);
                    }
                }
                if (!queue.hasCapacity && queue.bytes < maxQueueBytes && queue.depth < maxQueueDepth) {
                    queue.hasCapacity = true;
                    if (priority < this.lowestPriorityWithCapacity) {
                        int newLowestPriorityWithCapacity;
                        for (newLowestPriorityWithCapacity = priority; newLowestPriorityWithCapacity > 0 && this.queueArray[newLowestPriorityWithCapacity - 1].hasCapacity; --newLowestPriorityWithCapacity) {
                            this.queueArray[newLowestPriorityWithCapacity].monitor.setActive(false);
                        }
                        this.lowestPriorityWithCapacity = newLowestPriorityWithCapacity;
                        this.queueArray[this.lowestPriorityWithCapacity].monitor.setActive(false);
                    }
                }
            }
        }
        if (retValue != null) {
            if (this.type == Conversation.CLIENT) {
                clientQueuedBytes -= retValue.getSize();
            } else {
                meQueuedBytes -= retValue.getSize();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dequeue", (Object)retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCapacity(int priority) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasCapacity", (Object)("" + priority));
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            result = priority >= this.lowestPriorityWithCapacity;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasCapacity", (Object)("" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean immediate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)("" + immediate));
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            if (immediate || this.totalQueueDepth == 0) {
                this.state = CLOSED;
                this.closeWaitersMonitor.setActive(false);
            } else {
                this.state = CLOSING;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purge");
        }
        Object object = this.queueMonitor;
        synchronized (object) {
            this.state = CLOSED;
            for (int i = 0; i < 15; ++i) {
                this.queueArray[i].monitor.setActive(false);
            }
            this.closeWaitersMonitor.setActive(false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purge");
        }
    }

    public void waitForCloseToComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitForCloseToComplete");
        }
        this.closeWaitersMonitor.waitOn();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitForCloseToComplete");
        }
    }

    protected void setType(Conversation.ConversationType type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() throws SIConnectionDroppedException {
        Object object = this.queueMonitor;
        synchronized (object) {
            if (this.state == CLOSED) {
                throw new SIConnectionDroppedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"PRIORITY_QUEUE_PURGED_SICJ0077", null, (String)"PRIORITY_QUEUE_PURGED_SICJ0077"));
            }
            return this.totalQueueDepth == 0;
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/PriorityQueue.java, SIB.comms, WASX.SIB, uu1215.01 1.44");
        }
        try {
            maxQueueDepth = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.maxPriorityQueueDepth"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            maxQueueBytes = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.maxPriorityQueueBytes"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private class Queue
    extends CircularFIFOArrayBuffer {
        int depth;
        int bytes;
        boolean hasCapacity;
        ActivatableMonitor monitor;

        private Queue() {
            super(maxQueueDepth + 10);
            this.depth = 0;
            this.bytes = 0;
            this.hasCapacity = true;
            this.monitor = new ActivatableMonitor(false);
        }
    }

    private class CircularFIFOArrayBuffer {
        private TransmissionDataIterator[] array;
        private int size = 0;
        private int firstElementIndex = 0;
        private int maxSize = 0;

        public CircularFIFOArrayBuffer(int size) {
            this.array = new TransmissionDataIterator[size];
            this.maxSize = size;
        }

        public void enqueue(TransmissionDataIterator iterator) {
            this.array[(this.firstElementIndex + this.size) % this.maxSize] = iterator;
            ++this.size;
        }

        public TransmissionDataIterator dequeue() {
            TransmissionDataIterator result = null;
            if (this.size > 0) {
                result = this.array[this.firstElementIndex];
                this.array[this.firstElementIndex] = null;
                this.firstElementIndex = (this.firstElementIndex + 1) % this.maxSize;
                --this.size;
            }
            return result;
        }

        public TransmissionDataIterator head() {
            TransmissionDataIterator result = null;
            if (this.size > 0) {
                result = this.array[this.firstElementIndex];
            }
            return result;
        }
    }

    private static class ActivatableMonitor {
        private boolean enabled = true;

        public ActivatableMonitor(boolean enabled) {
            this.enabled = enabled;
        }

        public synchronized void waitOn() {
            if (this.enabled) {
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }

        private synchronized void setActive(boolean enabled) {
            if (this.enabled != enabled) {
                this.enabled = enabled;
                if (!enabled) {
                    this.notifyAll();
                }
            }
        }
    }

    private static final class StateEnum {
        private String description;

        private StateEnum(String description) {
            this.description = "PriorityQueue state: " + description;
        }

        public String toString() {
            return this.description;
        }
    }
}

