/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.threadpool.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.threadpool.ThreadPoolFullException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;

public class RichThreadPoolImpl
implements com.ibm.ws.sib.jfapchannel.threadpool.ThreadPool {
    private static final TraceComponent tc = SibTr.register(RichThreadPoolImpl.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ThreadPool wasThreadPool = null;

    @Override
    public void initialise(String name, int minSize, int maxSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialise", (Object)new Object[]{name, minSize, maxSize});
        }
        this.wasThreadPool = new ThreadPool(name, minSize, maxSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialise");
        }
    }

    @Override
    public void setGrowAsNeeded(boolean growAsNeeded) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGrowAsNeeded", (Object)growAsNeeded);
        }
        this.wasThreadPool.setGrowAsNeeded(growAsNeeded);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGrowAsNeeded");
        }
    }

    @Override
    public void execute(Runnable runnable, int was_thread_mode) throws InterruptedException, IllegalStateException, ThreadPoolFullException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object)new Object[]{runnable, was_thread_mode});
        }
        try {
            this.wasThreadPool.execute(runnable, was_thread_mode);
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught and rethrowing: ", (Object)((Object)e));
            }
            throw new ThreadPoolFullException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"execute");
        }
    }

    @Override
    public void execute(Runnable runnable) throws InterruptedException, IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object)runnable);
        }
        this.wasThreadPool.execute(runnable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"execute");
        }
    }

    @Override
    public void setKeepAliveTime(long msecs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setKeepAliveTime", (Object)msecs);
        }
        this.wasThreadPool.setKeepAliveTime(msecs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setKeepAliveTime");
        }
    }

    @Override
    public void setRequestBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRequestBufferSize", (Object)size);
        }
        this.wasThreadPool.setRequestBufferSize(size);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRequestBufferSize");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/threadpool/impl/RichThreadPoolImpl.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }
}

