/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.cdi.FaultToleranceCDIComponent;
import com.ibm.ws.microprofile.faulttolerance.spi.AsyncRequestContextController;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutorBuilder;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FaultToleranceProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorderProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.inject.Instance;
import java.lang.reflect.Method;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AggregatedFTPolicy {
    private Method method = null;
    private Class<?> asyncResultWrapper = null;
    private RetryPolicy retryPolicy = null;
    private CircuitBreakerPolicy circuitBreakerPolicy = null;
    private BulkheadPolicy bulkheadPolicy = null;
    private TimeoutPolicy timeout;
    private FallbackPolicy fallbackPolicy;
    private Executor<?> executor;
    private Instance<AsyncRequestContextController> rcInstance;
    static final long serialVersionUID = 8177097866152107714L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setAsynchronousResultWrapper(Class<?> asyncResultWrapper) {
        this.asyncResultWrapper = asyncResultWrapper;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeout) {
        this.timeout = timeout;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy) {
        this.circuitBreakerPolicy = circuitBreakerPolicy;
    }

    public void setBulkheadPolicy(BulkheadPolicy bulkheadPolicy) {
        this.bulkheadPolicy = bulkheadPolicy;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isAsynchronous() {
        return this.asyncResultWrapper != null;
    }

    public BulkheadPolicy getBulkheadPolicy() {
        return this.bulkheadPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeout;
    }

    public CircuitBreakerPolicy getCircuitBreakerPolicy() {
        return this.circuitBreakerPolicy;
    }

    public void setFallbackPolicy(FallbackPolicy fallbackPolicy) {
        this.fallbackPolicy = fallbackPolicy;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public void setRequestContextInstance(Instance<AsyncRequestContextController> rcInstance) {
        this.rcInstance = rcInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor<Object> getExecutor() {
        AggregatedFTPolicy aggregatedFTPolicy = this;
        synchronized (aggregatedFTPolicy) {
            if (this.executor == null) {
                ExecutorBuilder<?> builder = this.newBuilder();
                if (!this.rcInstance.isUnsatisfied() && !this.rcInstance.isAmbiguous()) {
                    builder.setRequestContextController((AsyncRequestContextController)this.rcInstance.get());
                }
                this.executor = this.isAsynchronous() ? builder.buildAsync(this.asyncResultWrapper) : builder.build();
            }
            return this.executor;
        }
    }

    private ExecutorBuilder<?> newBuilder() {
        ExecutorBuilder builder = FaultToleranceProvider.newExecutionBuilder();
        builder = this.updateBuilder(builder);
        return builder;
    }

    private <R> ExecutorBuilder<R> updateBuilder(ExecutorBuilder<R> builder) {
        TimeoutPolicy timeoutPolicy = this.getTimeoutPolicy();
        CircuitBreakerPolicy circuitBreakerPolicy = this.getCircuitBreakerPolicy();
        RetryPolicy retryPolicy = this.getRetryPolicy();
        FallbackPolicy fallbackPolicy = this.getFallbackPolicy();
        BulkheadPolicy bulkheadPolicy = this.getBulkheadPolicy();
        if (timeoutPolicy != null) {
            builder.setTimeoutPolicy(timeoutPolicy);
        }
        if (circuitBreakerPolicy != null) {
            builder.setCircuitBreakerPolicy(circuitBreakerPolicy);
        }
        if (retryPolicy != null) {
            builder.setRetryPolicy(retryPolicy);
        }
        if (fallbackPolicy != null) {
            builder.setFallbackPolicy(fallbackPolicy);
        }
        if (bulkheadPolicy != null) {
            builder.setBulkheadPolicy(bulkheadPolicy);
        }
        builder.setMetricRecorder(FaultToleranceCDIComponent.getMetricProvider().getMetricRecorder(this.method, retryPolicy, circuitBreakerPolicy, timeoutPolicy, bulkheadPolicy, fallbackPolicy, this.isAsynchronous() ? MetricRecorderProvider.AsyncType.ASYNC : MetricRecorderProvider.AsyncType.SYNC));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AggregatedFTPolicy aggregatedFTPolicy = this;
        synchronized (aggregatedFTPolicy) {
            if (this.executor != null) {
                this.executor.close();
                this.executor = null;
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance.cdi.AggregatedFTPolicy", AggregatedFTPolicy.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.cdi.resources.FaultToleranceCDI");
    }
}

