/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.utils;

import com.ibm.ws.product.utility.DefaultCommandConsole;
import com.ibm.ws.webserver.plugin.utility.utils.CommandUtils;
import com.ibm.ws.webserver.plugin.utility.utils.ConsoleWrapper;
import java.io.Console;
import java.io.PrintStream;

public class PluginUtilityConsole
extends DefaultCommandConsole {
    private final PrintStream stderr;
    private final PrintStream stdout;
    private final Console console;
    private ConsoleWrapper stdin;

    public PluginUtilityConsole(Console console, PrintStream stdout, PrintStream stderr) {
        super(console, stdout, stderr);
        this.stderr = stderr;
        this.stdout = stdout;
        this.stdin = new ConsoleWrapper(console, stderr);
        this.console = console;
    }

    public boolean isStandardOutAvailable() {
        return this.stdout != null;
    }

    public boolean isStandardErrorAvailable() {
        return this.stderr != null;
    }

    public String promptForUser(String arg) {
        String user = this.console.readLine(CommandUtils.getMessage("user.enterText", arg) + " ", new Object[0]);
        return user;
    }

    public String promptForPassword(String arg) {
        String password2;
        char[] pass1 = this.console.readPassword(CommandUtils.getMessage("password.enterText", arg) + " ", new Object[0]);
        char[] pass2 = this.console.readPassword(CommandUtils.getMessage("password.reenterText", arg) + " ", new Object[0]);
        if (pass1 == null && pass2 == null) {
            throw new IllegalArgumentException("Unable to read either entry. Aborting prompt.");
        }
        if (pass1 == null || pass2 == null) {
            this.stdout.println(CommandUtils.getMessage("password.readError", new Object[0]));
            return this.promptForPassword(arg);
        }
        String password1 = String.valueOf(pass1);
        if (password1.equals(password2 = String.valueOf(pass2))) {
            return password1;
        }
        this.stdout.println(CommandUtils.getMessage("password.entriesDidNotMatch", new Object[0]));
        return this.promptForPassword(arg);
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public ConsoleWrapper getStdin() {
        return this.stdin;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }
}

