/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.opentracing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import org.eclipse.microprofile.opentracing.Traced;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenTracingService {
    private static final String OPERATION_NAME_TRACED;
    private static final String OPERATION_NAME_UNTRACED;
    static final long serialVersionUID = 1559988509156287727L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getClassOperationName(Method method) {
        return OpenTracingService.getOperationName(method.getDeclaringClass().getAnnotation(Traced.class));
    }

    public static String getMethodOperationName(Method method) {
        return OpenTracingService.getOperationName(method.getAnnotation(Traced.class));
    }

    private static boolean isTraced(String operationName) {
        return operationName != null && !OPERATION_NAME_UNTRACED.equals(operationName);
    }

    public static boolean isTraced(String classOperationName, String methodOperationName) {
        return OpenTracingService.isTraced(methodOperationName) || OpenTracingService.isTraced(classOperationName) && !OPERATION_NAME_UNTRACED.equals(methodOperationName);
    }

    public static boolean isNotTraced(String classOperationName, String methodOperationName) {
        return OPERATION_NAME_UNTRACED.equals(methodOperationName) || OPERATION_NAME_UNTRACED.equals(classOperationName) && !OpenTracingService.isTraced(methodOperationName);
    }

    public static boolean hasExplicitOperationName(String operationName) {
        return operationName != null && !OPERATION_NAME_TRACED.equals(operationName) && !OPERATION_NAME_UNTRACED.equals(operationName);
    }

    public static String getOperationName(Traced traced) {
        String operationName = null;
        if (traced != null) {
            if (traced.value()) {
                operationName = traced.operationName();
                if (operationName == null || operationName.length() == 0) {
                    operationName = OPERATION_NAME_TRACED;
                }
            } else {
                operationName = OPERATION_NAME_UNTRACED;
            }
        }
        return operationName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.opentracing.internal.OpenTracingService", OpenTracingService.class, (String)"OPENTRACING", null);
        OPERATION_NAME_TRACED = OpenTracingService.class.getName() + ".TRACED";
        OPERATION_NAME_UNTRACED = OpenTracingService.class.getName() + ".UNTRACED";
    }
}

