/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.NotValue;
import com.ibm.ws.cache.config.Range;
import com.ibm.ws.cache.config.Value;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Component {
    private static TraceComponent tc = Tr.register(Component.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public String type;
    public String id;
    public boolean ignoreValue;
    public boolean multipleIds;
    public Method method;
    public Field field;
    public int index = -1;
    public boolean required;
    public HashMap values;
    public HashMap notValues;
    public ArrayList valueRanges;
    public ArrayList notValueRanges;
    public int iType;
    public Method idMethod;
    public Field idField;
    public static final int METHOD = 0;
    public static final int FIELD = 1;
    public static final int SESSION = 2;
    public static final int PARAMETER = 3;
    public static final int COOKIE = 4;
    public static final int HEADER = 5;
    public static final int LOCALE = 6;
    public static final int SOAP_ACTION = 7;
    public static final int SERVICE_OPERATION = 8;
    public static final int SERVICE_OPERATION_PARAMETER = 9;
    public static final int SOAP_ENVELOPE = 10;
    public static final int ATTRIBUTE = 11;
    public static final int PATH_INFO = 12;
    public static final int SERVLET_PATH = 13;
    public static final int PARAMETER_LIST = 14;
    public static final int OPERATION = 15;
    public static final int PART = 16;
    public static final int WSDL_SERVICE = 17;
    public static final int WSDL_PORT = 18;
    public static final int SOAP_HEADER_ENTRY = 19;
    public static final int REQUEST_TYPE = 20;
    public static final int TILES_ATTRIBUTE = 21;
    public static final int PORTLET_SESSION = 22;
    public static final int PORTLET_WINDOW_ID = 23;
    public static final int PORTLET_MODE = 24;
    public static final int PORTLET_WINDOW_STATE = 25;
    public static final int SESSION_ID = 26;

    public void validate() {
        if (this.type.equalsIgnoreCase("method")) {
            this.iType = 0;
        } else if (this.type.equalsIgnoreCase("field")) {
            this.iType = 1;
        } else if (this.type.equalsIgnoreCase("session")) {
            this.iType = 2;
        } else if (this.type.equalsIgnoreCase("parameter")) {
            this.iType = 3;
        } else if (this.type.equalsIgnoreCase("cookie")) {
            this.iType = 4;
        } else if (this.type.equalsIgnoreCase("header")) {
            this.iType = 5;
        } else if (this.type.equalsIgnoreCase("locale")) {
            this.iType = 6;
        } else if (this.type.equalsIgnoreCase("SOAPAction")) {
            this.iType = 7;
        } else if (this.type.equalsIgnoreCase("serviceOperation")) {
            this.iType = 8;
        } else if (this.type.equalsIgnoreCase("serviceOperationParameter")) {
            this.iType = 9;
        } else if (this.type.equalsIgnoreCase("SOAPEnvelope")) {
            this.iType = 10;
        } else if (this.type.equalsIgnoreCase("attribute")) {
            this.iType = 11;
        } else if (this.type.equalsIgnoreCase("pathInfo")) {
            this.iType = 12;
        } else if (this.type.equalsIgnoreCase("servletpath")) {
            this.iType = 13;
        } else if (this.type.equalsIgnoreCase("parameter-list")) {
            this.iType = 14;
        } else if (this.type.equalsIgnoreCase("operation")) {
            this.iType = 15;
        } else if (this.type.equalsIgnoreCase("part")) {
            this.iType = 16;
        } else if (this.type.equalsIgnoreCase("WSDLServiceName")) {
            this.iType = 17;
        } else if (this.type.equalsIgnoreCase("WSDLPortName")) {
            this.iType = 18;
        } else if (this.type.equalsIgnoreCase("SOAPHeaderEntry")) {
            this.iType = 19;
        } else if (this.type.equalsIgnoreCase("requestType")) {
            this.iType = 20;
        } else if (this.type.equalsIgnoreCase("tiles_attribute")) {
            this.iType = 21;
        } else if (this.type.equalsIgnoreCase("portletSession")) {
            this.iType = 22;
        } else if (this.type.equalsIgnoreCase("portletWindowId")) {
            this.iType = 23;
        } else if (this.type.equalsIgnoreCase("portletMode")) {
            this.iType = 24;
        } else if (this.type.equalsIgnoreCase("portletWindowState")) {
            this.iType = 25;
        } else if (this.type.equalsIgnoreCase("sessionId")) {
            this.iType = 26;
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA0049E", (Object[])new Object[]{this.type});
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("type       : " + this.type);
        pw.println("id         : " + this.id);
        pw.println("ignoreValue: " + this.ignoreValue);
        pw.println("mutipleIds : " + this.multipleIds);
        pw.println("method     : " + this.method);
        pw.println("index  : " + this.index);
        pw.println("required   : " + this.required);
        pw.println("values     : " + this.values);
        pw.println("not-values : " + this.notValues);
        pw.println("value ranges     : " + this.valueRanges);
        pw.println("not-value ranges : " + this.notValueRanges);
        return sw.toString();
    }

    public String fancyFormat(int level) {
        int ii;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("id         : " + this.id);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("type       : " + this.type);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("ignoreValue: " + this.ignoreValue);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("multipleIds   : " + this.multipleIds);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("method     : " + this.method);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("index  : " + this.index);
        for (ii = level; ii > 0; --ii) {
            pw.print("\t");
        }
        pw.println("required   : " + this.required);
        if (this.values != null && this.values.size() > 0) {
            for (ii = level; ii > 0; --ii) {
                pw.print("\t");
            }
            pw.println("value        : " + this.values);
            Iterator i = this.values.values().iterator();
            while (i.hasNext()) {
                pw.println(((Value)i.next()).fancyFormat(level + 1));
            }
        }
        if (this.notValues != null && this.notValues.size() > 0) {
            for (int ii2 = level; ii2 > 0; --ii2) {
                pw.print("\t");
            }
            pw.println("not-value    : " + this.notValues);
            Iterator i = this.notValues.values().iterator();
            while (i.hasNext()) {
                pw.println(((NotValue)i.next()).fancyFormat(level + 1));
            }
        }
        if (this.valueRanges != null && this.valueRanges.size() > 0) {
            for (int ii3 = level; ii3 > 0; --ii3) {
                pw.print("\t");
            }
            pw.println("value ranges     : " + this.valueRanges);
            Iterator i = this.valueRanges.iterator();
            while (i.hasNext()) {
                pw.println(((Range)i.next()).fancyFormat(level + 1));
            }
        }
        if (this.notValueRanges != null && this.notValueRanges.size() > 0) {
            for (int ii4 = level; ii4 > 0; --ii4) {
                pw.print("\t");
            }
            pw.println("not-value ranges : " + this.notValueRanges);
            Iterator i = this.notValueRanges.iterator();
            while (i.hasNext()) {
                pw.println(((Range)i.next()).fancyFormat(level + 1));
            }
        }
        return sw.toString();
    }

    public void getESIComponent(StringBuffer sb) {
        if (this.required) {
            if (this.ignoreValue) {
                sb.append("<").append(this.id);
                sb.append(">");
                this.getESIValues(sb);
            } else {
                sb.append(this.id);
                this.getESIValues(sb);
            }
        } else if (!this.required) {
            sb.append("[");
            if (this.ignoreValue) {
                sb.append("<").append(this.id);
                sb.append(">");
                this.getESIValues(sb);
            } else {
                sb.append(this.id);
                this.getESIValues(sb);
            }
            sb.append("]");
        }
    }

    public void getESIValues(StringBuffer sb) {
        if (this.values != null && this.values.size() > 0) {
            sb.append("={");
            Iterator i = this.values.values().iterator();
            while (i.hasNext()) {
                sb.append(((Value)i.next()).value);
                if (!i.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("}");
        } else if (this.notValues != null && this.notValues.size() > 0) {
            sb.append("={");
            Iterator i = this.notValues.values().iterator();
            while (i.hasNext()) {
                sb.append(((NotValue)i.next()).notValue);
                if (!i.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("}");
        }
    }

    public Object clone() {
        Iterator<Object> i;
        Component c = new Component();
        c.type = this.type;
        c.iType = this.iType;
        c.id = this.id;
        c.ignoreValue = this.ignoreValue;
        c.multipleIds = this.multipleIds;
        c.required = this.required;
        if (this.method != null) {
            c.method = (Method)this.method.clone();
        }
        if (this.field != null) {
            c.field = (Field)this.field.clone();
        }
        c.index = this.index;
        if (this.values != null) {
            c.values = new HashMap();
            for (Object key : this.values.keySet()) {
                c.values.put(key, ((Value)this.values.get(key)).clone());
            }
        }
        if (this.notValues != null) {
            c.notValues = new HashMap();
            for (Object key : this.notValues.keySet()) {
                c.notValues.put(key, ((NotValue)this.notValues.get(key)).clone());
            }
        }
        if (this.valueRanges != null) {
            c.valueRanges = new ArrayList();
            if (this.valueRanges != null) {
                c.valueRanges = new ArrayList();
                i = this.valueRanges.iterator();
                while (i.hasNext()) {
                    c.valueRanges.add(((Range)i.next()).clone());
                }
            }
        }
        if (this.notValueRanges != null) {
            c.notValueRanges = new ArrayList();
            if (this.notValueRanges != null) {
                c.notValueRanges = new ArrayList();
                i = this.notValueRanges.iterator();
                while (i.hasNext()) {
                    c.notValueRanges.add(((Range)i.next()).clone());
                }
            }
        }
        return c;
    }
}

