/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.filemgr;

import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.PrimitiveArrayPool;
import com.ibm.ws.cache.persistent.filemgr.Constants;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import com.ibm.ws.cache.persistent.filemgr.Instrumentation;
import com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper;
import com.ibm.ws.cache.persistent.filemgr.PhysicalFileInterface;
import com.ibm.ws.cache.persistent.util.ByteArrayPlusOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileManagerImpl
implements FileManager,
Constants,
Instrumentation {
    private long allocs = 0L;
    private long deallocs = 0L;
    private long coalesces = 0L;
    private long allocated_blocks = 0L;
    private long free_blocks = 0L;
    private long allocated_words = 0L;
    private long free_words = 0L;
    private long seeks = 0L;
    private long small_requests = 0L;
    private long large_requests = 0L;
    private long ql_hits = 0L;
    private long ml_hits = 0L;
    private long ml_splits = 0L;
    private long ml_blocks_searched = 0L;
    private int fast_startups = 0;
    private int nonempty_lists = 0;
    private long write_time = 0L;
    private long read_time = 0L;
    private int read_count = 0;
    private int write_count = 0;
    private long bytes_read = 0L;
    private long bytes_written = 0L;
    private int first_quick_size = 1;
    private int last_quick_size = 75;
    private int grain_size = 512;
    private int acceptable_waste = 2000;
    private int first_quick_size_block;
    private int last_quick_size_block;
    private int last_ql_index;
    private boolean readOnly;
    private long tail_ptr;
    private String filename;
    private int type;
    private int truetype;
    private Listhead[] ql_heads;
    private long[][] userData = new long[128][2];
    private PhysicalFileInterface physical = null;
    private HTODDynacache htoddc = null;

    public FileManagerImpl(String fname, boolean coalesce_blocks, String mode, int type, HTODDynacache htoddc) throws FileManagerException, IOException {
        this.type = type;
        this.htoddc = htoddc;
        if (type != 2) {
            throw new FileManagerException("Unknown type: " + type);
        }
        this.physical = new MultivolumeRAFWrapper(fname, mode, this, htoddc.getDiskCacheSizeInfo());
        this.filename = fname;
        this.readOnly = mode.equals("r");
        if (this.length() == 0L) {
            if (this.readOnly) {
                throw new FileManagerException("Attempt to open an empty file in read only mode");
            }
            this.tail_ptr = 16384L;
            this.seek(0L);
            this.writeLong(44534132L);
            this.writeLong(16384L);
            this.writeLong(0L);
            this.writeInt(this.first_quick_size);
            this.writeInt(this.last_quick_size);
            this.writeInt(this.grain_size);
            this.writeInt(this.acceptable_waste);
            byte[] clear = new byte[128];
            this.write(clear);
            clear = new byte[2048];
            this.write(clear);
            this.init_freelists(true);
        } else {
            this.seek(0L);
            long magic_number = this.readLong();
            if (magic_number != 44534132L) {
                throw new FileManagerException("File not valid (invalid magic string). Expected 44534132 received " + magic_number);
            }
            this.tail_ptr = this.readLong();
            if (this.tail_ptr < 16384L) {
                throw new FileManagerException("File not valid (illegal tail pointer)");
            }
            long cache_end = this.readLong();
            if (cache_end < 0L) {
                throw new FileManagerException("File not valid (illegal end of cache pointer)");
            }
            this.first_quick_size = this.readInt();
            if (this.first_quick_size < 1) {
                throw new FileManagerException("File not valid (illegal first quick size)");
            }
            this.last_quick_size = this.readInt();
            if (this.last_quick_size < this.first_quick_size) {
                throw new FileManagerException("File not valid (illegal last quick size)");
            }
            this.grain_size = this.readInt();
            if (this.grain_size < 1) {
                throw new FileManagerException("File not valid (illegal grain size)");
            }
            this.acceptable_waste = this.readInt();
            this.read_user_data();
            this.init_freelists(true);
            if (this.acceptable_waste < 1) {
                throw new FileManagerException("File not valid (illegal acceptable waste)");
            }
            if (coalesce_blocks && !this.readOnly) {
                this.read_block_sizes_from_disk(true);
                this.seek(16L);
                this.writeLong(0L);
            } else if (cache_end == 0L) {
                this.read_block_sizes_from_disk(false);
            } else {
                this.read_block_sizes_from_cache(cache_end);
            }
        }
    }

    private void read_user_data() throws IOException {
        this.seek(168L);
        for (int i = 0; i < 128; ++i) {
            this.userData[i][0] = this.readLong();
            this.userData[i][1] = this.readLong();
        }
    }

    private void writeUserData(int ndx) throws IOException {
        long location = 168L + (long)(ndx * 2 * 8);
        this.seek(location);
        this.writeLong(this.userData[ndx][0]);
        this.writeLong(this.userData[ndx][1]);
    }

    @Override
    public long fetchUserData(long instanceid) throws IOException {
        for (int i = 0; i < 128; ++i) {
            if (this.userData[i][0] != instanceid) continue;
            return this.userData[i][1];
        }
        return 0L;
    }

    @Override
    public boolean storeUserData(long instanceid, long data) throws IOException, FileManagerException {
        int i;
        if (instanceid == 0L) {
            return false;
        }
        for (i = 0; i < 128; ++i) {
            if (this.userData[i][0] != instanceid) continue;
            this.userData[i][1] = data;
            this.writeUserData(i);
            return true;
        }
        for (i = 0; i < 128; ++i) {
            if (this.userData[i][0] != 0L) continue;
            this.userData[i][0] = instanceid;
            this.userData[i][1] = data;
            this.writeUserData(i);
            return true;
        }
        throw new FileManagerException("storeUserdata: No remaining slots");
    }

    @Override
    public String filename() {
        return this.physical.filename();
    }

    @Override
    public long length() throws IOException {
        return this.physical.length();
    }

    @Override
    public void close() throws IOException {
        this.cache_free_storage_info();
        this.physical.close();
    }

    @Override
    public void flush() throws IOException {
        this.physical.flush();
    }

    @Override
    public int read() throws IOException {
        ++this.bytes_read;
        return this.physical.read();
    }

    @Override
    public int read(byte[] v) throws IOException {
        int answer = this.physical.read(v);
        this.bytes_read += (long)answer;
        return answer;
    }

    @Override
    public int read(byte[] v, int off, int len) throws IOException {
        int answer = this.physical.read(v, off, len);
        this.bytes_read += (long)answer;
        return answer;
    }

    @Override
    public int readInt() throws IOException {
        this.bytes_read += 4L;
        return this.physical.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.bytes_read += 8L;
        return this.physical.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.bytes_read += 2L;
        return this.physical.readShort();
    }

    @Override
    public void seek(long loc) throws IOException {
        this.physical.seek(loc);
    }

    @Override
    public void write(byte[] v) throws IOException {
        this.physical.write(v);
        this.bytes_written += (long)v.length;
    }

    @Override
    public void write(byte[] v, int off, int len) throws IOException {
        this.physical.write(v, off, len);
        this.bytes_written += (long)len;
    }

    @Override
    public void write(int v) throws IOException {
        this.physical.write(v);
        ++this.bytes_written;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.physical.writeInt(v);
        this.bytes_written += 4L;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.physical.writeLong(v);
        this.bytes_written += 8L;
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.physical.writeShort(v);
        this.bytes_written += 2L;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void init_storage_parameters() {
        this.first_quick_size_block = this.first_quick_size * this.grain_size;
        this.last_quick_size_block = this.last_quick_size * this.grain_size;
        this.last_ql_index = this.last_quick_size + 1 - this.first_quick_size;
        this.ql_heads = new Listhead[this.last_ql_index + 1];
    }

    private void init_freelists(boolean create) {
        if (create) {
            this.init_storage_parameters();
        }
        for (int qlist_num = 0; qlist_num <= this.last_ql_index; ++qlist_num) {
            if (create) {
                this.ql_heads[qlist_num] = new Listhead();
            }
            this.ql_heads[qlist_num].length = 0;
            this.ql_heads[qlist_num].first_block = null;
        }
        this.nonempty_lists = 0;
    }

    private void read_tail_from_disk() throws IOException {
        this.seek(8L);
        this.tail_ptr = this.readLong();
    }

    private int combine_blocks(long addr) throws IOException {
        long next_addr = addr;
        int length = this.readInt();
        if (length > 0) {
            long cum_length;
            while (length > 0 && next_addr + (long)length < this.tail_ptr) {
                this.seek(next_addr += (long)length);
                length = this.readInt();
            }
            if (length < 0) {
                cum_length = next_addr - addr;
                this.seek(addr);
                this.writeInt((int)cum_length);
            } else {
                cum_length = this.tail_ptr - addr;
            }
            return (int)cum_length;
        }
        return length;
    }

    private void read_block_sizes_from_disk(boolean coalesce_blocks) throws IOException {
        int length;
        long new_tail = this.tail_ptr;
        for (long addr = 16384L; addr < this.tail_ptr; addr += (long)length) {
            this.seek(addr);
            length = coalesce_blocks ? this.combine_blocks(addr) : this.readInt();
            if (length > 0) {
                if ((long)length + addr >= this.tail_ptr && !this.readOnly) {
                    new_tail = addr;
                    continue;
                }
                this.add_to_freelist(addr, length);
                continue;
            }
            length = -length;
            ++this.allocated_blocks;
            this.allocated_words += (long)length;
        }
        if (new_tail != this.tail_ptr && !this.readOnly) {
            this.tail_ptr = new_tail;
            this.seek(8L);
            this.writeLong(this.tail_ptr);
        }
    }

    private void read_block_sizes_from_cache(long cache_end) throws IOException {
        byte[] buf = new byte[(int)(cache_end - this.tail_ptr)];
        this.seek(this.tail_ptr);
        this.read(buf);
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        this.allocated_blocks = dis.readLong();
        this.allocated_words = dis.readLong();
        this.free_blocks = 0L;
        this.free_words = 0L;
        long cache_cursor = this.tail_ptr + 16L;
        while (cache_cursor < cache_end) {
            int list_index = dis.readInt();
            long block_address = dis.readLong();
            cache_cursor += 12L;
            while (block_address != 0L) {
                int block_size = dis.readInt();
                this.add_new_block_to_freelist(block_address, block_size, list_index);
                block_address = dis.readLong();
                cache_cursor += 12L;
            }
        }
        dis.close();
        bis.close();
        if (!this.readOnly) {
            this.seek(16L);
            this.writeLong(0L);
        }
        ++this.fast_startups;
    }

    @Override
    public void cache_free_storage_info() throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to cache free storage information in read only mode");
        }
        long cache_size = 16L + (this.free_blocks + (long)this.nonempty_lists) * 12L;
        ByteArrayPlusOutputStream bos = new ByteArrayPlusOutputStream((int)cache_size);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(this.allocated_blocks);
        dos.writeLong(this.allocated_words);
        for (int qlist_num = 0; qlist_num <= this.last_ql_index; ++qlist_num) {
            if (this.ql_heads[qlist_num].first_block == null) continue;
            dos.writeInt(qlist_num);
            Block block = this.ql_heads[qlist_num].first_block;
            while (block != null) {
                dos.writeLong(block.address);
                dos.writeInt(block.size);
                block = block.next;
            }
            dos.writeLong(0L);
        }
        dos.close();
        bos.close();
        byte[] buf = bos.getTheBuffer();
        this.seek(this.tail_ptr);
        this.write(buf);
        this.seek(16L);
        this.writeLong(this.tail_ptr + cache_size);
    }

    @Override
    public void dump_disk_memory(Writer out) throws IOException {
        out.write("Information stored on disk\n");
        this.seek(0L);
        long magic = this.readLong();
        out.write("File magic number: " + magic + "\n");
        this.seek(8L);
        long tail = this.readLong();
        out.write("Tail on disk: " + tail + "\n");
        long cache_end = this.readLong();
        out.write("End of cached free list info: " + cache_end + "\n");
        int size = this.readInt();
        out.write("First quick size: " + size + "\n");
        size = this.readInt();
        out.write("Last quick size: " + size + "\n");
        size = this.readInt();
        out.write("Grain size: " + size + "\n");
        size = this.readInt();
        out.write("Acceptable waste: " + size + "\n");
        for (long block_ptr = 16384L; block_ptr < tail; block_ptr += (long)this.abs(size)) {
            this.seek(block_ptr);
            size = this.readInt();
            out.write(block_ptr + ", " + size + "\n");
        }
        out.write("\n\n");
    }

    private void seek_and_count(long offset) throws IOException {
        this.seek(offset);
        ++this.seeks;
    }

    private void print_memory_freelist(Writer out, Block block) throws IOException {
        while (block != null) {
            out.write(block.address + " " + block.size + ", ");
            block = block.next;
        }
        out.write("\n");
    }

    @Override
    public void reset_stats() {
        this.seeks = 0L;
        this.small_requests = 0L;
        this.large_requests = 0L;
        this.ql_hits = 0L;
        this.ml_hits = 0L;
        this.ml_splits = 0L;
        this.ml_blocks_searched = 0L;
        this.fast_startups = 0;
        this.deallocs = 0L;
        this.allocs = 0L;
        this.read_count = 0;
        this.write_count = 0;
        this.read_time = 0L;
        this.write_time = 0L;
        this.bytes_read = 0L;
        this.bytes_written = 0L;
    }

    @Override
    public void dump_stats_header(Writer out) throws IOException {
        out.write("Filename\t");
        out.write("Allocations\t");
        out.write("Deallocations\t");
        out.write("Coalesces\t");
        out.write("Alloc-Blocks\t");
        out.write("Allocated-Words\t");
        out.write("Free-Blocks\t");
        out.write("Free-Words\t");
        out.write("Seeks\t");
        out.write("Reads\t");
        out.write("Writes\t");
        out.write("Read-Time\t");
        out.write("Write-Time\t");
        out.write("Bytes-Read\t");
        out.write("Bytes-Written\t");
        out.write("Small-Requests\t");
        out.write("Large-Requests\t");
        out.write("QL-Hits\t");
        out.write("ML-Hits\t");
        out.write("ML-Splits\t");
        out.write("ML-Blocks_searched\t");
        out.write("Fast-Startups\t");
    }

    @Override
    public void dump_stats(Writer out, boolean labels) throws IOException {
        if (labels) {
            out.write("--------------------------------------------------\n");
            out.write("FileManager Header:\n");
            out.write("--------------------------------------------------\n");
            out.write("Filename = " + this.filename + "\n");
            out.write("Allocations: " + this.allocs + "\n");
            out.write("Deallocations: " + this.deallocs + "\n");
            out.write("Coalesces: " + this.coalesces + "\n");
            out.write("Allocated blocks: " + this.allocated_blocks + "\n");
            out.write("Allocated bytes: " + this.allocated_words + "\n");
            out.write("Free blocks: " + this.free_blocks + "\n");
            out.write("Free bytes: " + this.free_words + "\n");
            out.write("Seeks: " + this.seeks + "\n");
            out.write("Requests for small blocks: " + this.small_requests + "\n");
            out.write("Requests for large blocks: " + this.large_requests + "\n");
            out.write("Quick list hits: " + this.ql_hits + "\n");
            out.write("Misc list hits: " + this.ml_hits + "\n");
            out.write("Block splits (from misc list): " + this.ml_splits + "\n");
            out.write("Misc list blocks searched: " + this.ml_blocks_searched + "\n");
            out.write("Fast startups: " + this.fast_startups + "\n");
            out.write("Read requests: " + this.read_count + "\n");
            out.write("Write requests: " + this.write_count + "\n");
            out.write("Accumulated physical read time:" + this.read_time + "\n");
            out.write("Accumulated physical write time:" + this.write_time + "\n");
            out.write("Bytes read: " + this.bytes_read + "\n");
            out.write("Bytes written: " + this.bytes_written + "\n");
        } else {
            out.write(this.filename + "\t");
            out.write(this.allocs + "\t");
            out.write(this.deallocs + "\t");
            out.write(this.coalesces + "\t");
            out.write(this.allocated_blocks + "\t");
            out.write(this.allocated_words + "\t");
            out.write(this.free_blocks + "\t");
            out.write(this.free_words + "\t");
            out.write(this.seeks + "\t");
            out.write(this.read_count + "\t");
            out.write(this.write_count + "\t");
            out.write(this.read_time + "\t");
            out.write(this.write_time + "\t");
            out.write(this.bytes_read + "\t");
            out.write(this.bytes_written + "\t");
            out.write(this.small_requests + "\t");
            out.write(this.large_requests + "\t");
            out.write(this.ql_hits + "\t");
            out.write(this.ml_hits + "\t");
            out.write(this.ml_splits + "\t");
            out.write(this.ml_blocks_searched + "\t");
            out.write(this.fast_startups + "\t");
        }
    }

    @Override
    public void dump_memory(Writer out) throws IOException {
        out.write("First quick size: " + this.first_quick_size + "\n");
        out.write("Last quick size: " + this.last_quick_size + "\n");
        out.write("Grain size: " + this.grain_size + "\n");
        out.write("Acceptable waste: " + this.acceptable_waste + "\n");
        out.write("Tail pointer in memory: " + this.tail_ptr + "\n");
        out.write("First allocatable byte: " + this.start() + "\n\n");
        out.write("Free lists from memory structures\n");
        for (int qlist_num = 0; qlist_num <= this.last_ql_index; ++qlist_num) {
            out.write(qlist_num + ": ");
            out.write("Length = " + this.ql_heads[qlist_num].length + "; ");
            this.print_memory_freelist(out, this.ql_heads[qlist_num].first_block);
        }
        out.write("Nonempty free lists: " + this.nonempty_lists + "\n");
        out.write("Tail pointer in memory: " + this.tail_ptr + "\n");
        out.write("First allocatable byte: " + this.start() + "\n\n");
    }

    private int calculate_list_index_for_alloc(int size) {
        int junk = 0;
        if ((size - this.first_quick_size_block) % this.grain_size > 0) {
            junk = 1;
        }
        return junk + (size - this.first_quick_size_block) / this.grain_size;
    }

    private int calculate_list_index_for_dealloc(int size) {
        return (size - this.first_quick_size_block) / this.grain_size;
    }

    private int abs(int size) {
        if (size > 0) {
            return size;
        }
        return -size;
    }

    private int calculate_block_size(int ql_index) {
        return this.first_quick_size_block + ql_index * this.grain_size;
    }

    private long allocate_from_tail(int block_size) throws IOException {
        long block_to_alloc = this.tail_ptr;
        this.tail_ptr += (long)block_size;
        ++this.allocated_blocks;
        this.allocated_words += (long)block_size;
        this.seek_and_count(block_to_alloc);
        this.writeInt(-block_size);
        this.seek_and_count(8L);
        this.writeLong(this.tail_ptr);
        return block_to_alloc + 4L;
    }

    private long allocate_from_ql(int request_size) throws IOException {
        ++this.small_requests;
        int list_index = this.calculate_list_index_for_alloc(request_size);
        if (this.ql_heads[list_index].length > 0) {
            Block block1 = this.ql_heads[list_index].first_block;
            --this.ql_heads[list_index].length;
            if (this.ql_heads[list_index].length == 0) {
                --this.nonempty_lists;
            }
            this.ql_heads[list_index].first_block = block1.next;
            ++this.allocated_blocks;
            --this.free_blocks;
            ++this.ql_hits;
            this.allocated_words += (long)block1.size;
            this.free_words -= (long)block1.size;
            this.seek_and_count(block1.address);
            this.writeInt(-block1.size);
            return block1.address + 4L;
        }
        int block_size = this.calculate_block_size(list_index);
        return this.allocate_from_tail(block_size);
    }

    private long split_block(long block_addr, int request_size, int rem) throws IOException {
        this.allocated_words += (long)request_size;
        ++this.allocated_blocks;
        this.free_words -= (long)request_size;
        ++this.ml_hits;
        ++this.ml_splits;
        this.seek_and_count(block_addr + (long)request_size);
        this.writeInt(rem);
        this.seek_and_count(block_addr);
        this.writeInt(-request_size);
        return block_addr + 4L;
    }

    private long search_ml(int request_size) throws IOException {
        int rem;
        Block best_candidate = null;
        Block best_candidate_pred = null;
        Block block = this.ql_heads[this.last_ql_index].first_block;
        boolean found = false;
        Block prev_block = null;
        ++this.large_requests;
        while (block != null) {
            ++this.ml_blocks_searched;
            if (block.size >= request_size) {
                rem = block.size - request_size;
                if (rem <= this.acceptable_waste) {
                    if (prev_block != null) {
                        prev_block.next = block.next;
                    } else {
                        this.ql_heads[this.last_ql_index].first_block = block.next;
                    }
                    --this.ql_heads[this.last_ql_index].length;
                    if (this.ql_heads[this.last_ql_index].length == 0) {
                        --this.nonempty_lists;
                    }
                    ++this.allocated_blocks;
                    --this.free_blocks;
                    ++this.ml_hits;
                    this.allocated_words += (long)block.size;
                    this.free_words -= (long)block.size;
                    this.seek_and_count(block.address);
                    this.writeInt(-block.size);
                    return block.address + 4L;
                }
                if (best_candidate == null) {
                    best_candidate = block;
                    best_candidate_pred = prev_block;
                } else if (best_candidate.size >= block.size) {
                    best_candidate = block;
                    best_candidate_pred = prev_block;
                }
            }
            prev_block = block;
            block = block.next;
        }
        if (best_candidate == null) {
            return this.allocate_from_tail(request_size);
        }
        rem = best_candidate.size - request_size;
        long block_addr = best_candidate.address;
        if (rem <= this.last_quick_size_block) {
            int rem2 = rem % this.grain_size;
            int ql_index = this.calculate_list_index_for_dealloc(rem -= rem2);
            request_size += rem2;
            if (best_candidate_pred != null) {
                best_candidate_pred.next = best_candidate.next;
            } else {
                this.ql_heads[this.last_ql_index].first_block = best_candidate.next;
            }
            this.add_block_to_freelist(best_candidate, ql_index);
        }
        best_candidate.size = rem;
        best_candidate.address += (long)request_size;
        return this.split_block(block_addr, request_size, rem);
    }

    @Override
    public long start() {
        return 16388L;
    }

    @Override
    public int grain_size() {
        return this.grain_size;
    }

    @Override
    public long allocateAndClear(int size) throws FileManagerException, IOException, EOFException {
        long ret = this.allocate(size);
        PrimitiveArrayPool.PoolEntry bytePoolEntry = this.htoddc.byteArrayPool.allocate(size);
        byte[] clear = (byte[])bytePoolEntry.getArray();
        this.seek(ret);
        this.write(clear);
        this.htoddc.byteArrayPool.returnToPool(bytePoolEntry);
        return ret;
    }

    @Override
    public long allocate(int request_size) throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to allocate in read only mode");
        }
        ++this.allocs;
        if ((request_size += 4) <= this.last_quick_size_block) {
            return this.allocate_from_ql(request_size);
        }
        request_size = (request_size + this.grain_size - 1) / this.grain_size * this.grain_size;
        return this.search_ml(request_size);
    }

    private int get_block_size(long block) throws IOException {
        this.seek_and_count(block);
        return this.readInt();
    }

    private void add_block_to_freelist(Block block, int ql_index) {
        block.next = this.ql_heads[ql_index].first_block;
        this.ql_heads[ql_index].first_block = block;
        ++this.ql_heads[ql_index].length;
        if (this.ql_heads[ql_index].length == 1) {
            ++this.nonempty_lists;
        }
    }

    private void add_new_block_to_freelist(long addr, int size, int ql_index) {
        Block block = new Block();
        block.address = addr;
        block.size = size;
        this.add_block_to_freelist(block, ql_index);
        ++this.free_blocks;
        this.free_words += (long)size;
    }

    private void add_to_freelist(long addr, int size) {
        int list_index = size <= this.last_quick_size_block ? this.calculate_list_index_for_dealloc(size) : this.last_ql_index;
        this.add_new_block_to_freelist(addr, size, list_index);
    }

    @Override
    public void deallocate(long block) throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to deallocate in read only mode");
        }
        if ((block -= 4L) < 16384L) {
            throw new FileManagerException("Illegal block address passed to deallocate");
        }
        int size = this.get_block_size(block);
        if (size >= 0) {
            throw new FileManagerException("Attempt to deallocate block with illegal size");
        }
        size = this.abs(size);
        ++this.deallocs;
        this.seek_and_count(block);
        this.writeInt(size);
        this.add_to_freelist(block, size);
        --this.allocated_blocks;
        this.allocated_words -= (long)size;
    }

    @Override
    public void coalesce() throws IOException {
        if (this.readOnly) {
            throw new FileManagerException("Attempt to coalesce in read only mode");
        }
        this.free_blocks = 0L;
        this.free_words = 0L;
        this.allocated_blocks = 0L;
        this.allocated_words = 0L;
        this.init_freelists(false);
        this.read_block_sizes_from_disk(true);
        ++this.coalesces;
    }

    @Override
    public void update_read_time(long time) {
        this.read_time += time;
    }

    @Override
    public void update_write_time(long time) {
        this.write_time += time;
    }

    @Override
    public void increment_read_count() {
        ++this.read_count;
    }

    @Override
    public void increment_write_count() {
        ++this.write_count;
    }

    private void run_tests() throws IOException {
        long block1 = this.allocate(900);
        long block2 = this.allocate(900);
        long block3 = this.allocate(900);
        long block4 = this.allocate(1900);
        long block5 = this.allocate(2900);
        long block6 = this.allocate(900);
        long block7 = this.allocate(7900);
        this.deallocate(block1);
        this.deallocate(block2);
        this.deallocate(block3);
        this.deallocate(block4);
        this.deallocate(block5);
        this.deallocate(block6);
        this.deallocate(block7);
        this.cache_free_storage_info();
    }

    public static void main(String[] args) throws FileManagerException, IOException {
        HTODDynacache hdc = new HTODDynacache();
        FileManagerImpl mem_manager = new FileManagerImpl("foo1", false, "rw", 2, hdc);
        mem_manager.run_tests();
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        mem_manager.dump_disk_memory(out);
        mem_manager.dump_memory(out);
        mem_manager.dump_stats(out, false);
        mem_manager.cache_free_storage_info();
        mem_manager.dump_disk_memory(out);
        out.flush();
        out.close();
    }

    class Listhead {
        public int length;
        public Block first_block;

        Listhead() {
        }
    }

    class Block {
        public long address;
        public int size;
        public Block next;

        Block() {
        }
    }
}

