/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.util.WsObjectInputStream;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.library.Library;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class SerializationUtility {
    private static TraceComponent tc = Tr.register(SerializationUtility.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private final AtomicServiceReference<SerializationService> serializationServiceRef = new AtomicServiceReference("serializationService");
    private static SerializationUtility _instance;
    private static BundleContext _bundleContext;

    public static ClassLoader getContextClassLoader() {
        return threadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
    }

    public void activate(ComponentContext context) {
        this.serializationServiceRef.activate(context);
        _instance = this;
        _bundleContext = context.getBundleContext();
    }

    public void deactivate(ComponentContext context) {
        this.serializationServiceRef.deactivate(context);
        _instance = null;
        _bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] serialize(Serializable serializable) throws IOException {
        SerializationService ss;
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        byte[] result = null;
        if (null != _instance && null != (ss = (SerializationService)SerializationUtility._instance.serializationServiceRef.getService())) {
            objectOutputStream = ss.createObjectOutputStream((OutputStream)byteArrayOutputStream);
        }
        if (null == objectOutputStream) {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        try {
            objectOutputStream.writeObject(serializable);
            result = byteArrayOutputStream.toByteArray();
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        return result;
    }

    public static Library getSharedLibrary(String cacheName) {
        Library sharedLib = null;
        try {
            Collection cacheServiceRefs = _bundleContext.getServiceReferences(CacheService.class, "(id=" + cacheName + ")");
            if (null != cacheServiceRefs && !cacheServiceRefs.isEmpty()) {
                ServiceReference csRef = (ServiceReference)cacheServiceRefs.iterator().next();
                CacheService cs = (CacheService)_bundleContext.getService(csRef);
                sharedLib = cs.getSharedLibrary();
            }
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)SerializationUtility.class.getName(), (String)"getSharedLibrary");
        }
        return sharedLib;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static final Serializable deserialize(byte[] array, String cacheName) throws IOException, ClassNotFoundException {
        if (array == null) {
            return null;
        }
        Serializable object = null;
        try {
            block9: {
                SerializationService ss;
                if (null != _instance && null != (ss = (SerializationService)SerializationUtility._instance.serializationServiceRef.getService())) {
                    try {
                        ClassLoader tccl = SerializationUtility.getContextClassLoader();
                        ObjectInputStream objectInputStream = ss.createObjectInputStream((InputStream)new ByteArrayInputStream(array), tccl);
                        object = (Serializable)objectInputStream.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        Library sharedLib;
                        if (null == cacheName || null == (sharedLib = SerializationUtility.getSharedLibrary(cacheName))) break block9;
                        DeserializationObjectInputStream objectInputStream = new DeserializationObjectInputStream((InputStream)new ByteArrayInputStream(array), sharedLib.getClassLoader());
                        object = (Serializable)objectInputStream.readObject();
                    }
                }
            }
            if (null == object) {
                object = SerializationUtility.deserializeUsingTCCL(array, 0, array.length, SerializationUtility.getContextClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            object = SerializationUtility.deserialize(array, 0, array.length);
        }
        return object;
    }

    private static final Serializable deserialize(byte[] array, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(array, offset, length);
            byteArrayInputStream.mark(array.length);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Serializable serializable = (Serializable)objectInputStream.readObject();
            return serializable;
        }
        catch (ClassNotFoundException cnfe) {
            ClassLoader cl = SerializationUtility.getClassLoader();
            if (cl != null) {
                byteArrayInputStream.reset();
                objectInputStream = new WsObjectInputStream(byteArrayInputStream, cl);
                Serializable serializable = (Serializable)objectInputStream.readObject();
                return serializable;
            }
            throw cnfe;
        }
        catch (NoClassDefFoundError cnfe) {
            ClassLoader cl = SerializationUtility.getClassLoader();
            if (cl != null) {
                byteArrayInputStream.reset();
                objectInputStream = new WsObjectInputStream(byteArrayInputStream, cl);
                Serializable serializable = (Serializable)objectInputStream.readObject();
                return serializable;
            }
            throw cnfe;
        }
        catch (StreamCorruptedException cnfe) {
            ClassLoader cl = SerializationUtility.getClassLoader();
            if (cl != null) {
                byteArrayInputStream.reset();
                objectInputStream = new WsObjectInputStream(byteArrayInputStream, cl);
                Serializable serializable = (Serializable)objectInputStream.readObject();
                return serializable;
            }
            throw cnfe;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    private static final Serializable deserializeUsingTCCL(byte[] array, int offset, int length, ClassLoader tccl) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(array, offset, length);
            byteArrayInputStream.mark(array.length);
            byteArrayInputStream.reset();
            objectInputStream = new WsObjectInputStream(byteArrayInputStream, tccl);
            Object obj = objectInputStream.readObject();
            Serializable serializable = (Serializable)obj;
            return serializable;
        }
        catch (ClassNotFoundException cnfe) {
            FFDCFilter.processException((Throwable)cnfe, (String)(SerializationUtility.class.getName() + ".deserializeUsingTCCL()"), (String)"248");
            throw cnfe;
        }
        catch (StreamCorruptedException cnfe) {
            FFDCFilter.processException((Throwable)cnfe, (String)(SerializationUtility.class.getName() + ".deserializeUsingTCCL()"), (String)"251");
            throw cnfe;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    private static ClassLoader getClassLoader() {
        if (null == _bundleContext) {
            return SerializationUtility.class.getClassLoader();
        }
        return _bundleContext.getClass().getClassLoader();
    }

    protected void setSerializationService(ServiceReference<SerializationService> ref) {
        this.serializationServiceRef.setReference(ref);
    }

    protected void unsetSerializationService(ServiceReference<SerializationService> ref) {
        this.serializationServiceRef.unsetReference(ref);
    }
}

