/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;

@Trivial
public class MessageImpl
extends StringMapImpl
implements Message {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageImpl.class);
    private static final long serialVersionUID = -3020763696429459865L;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Object[] contents = new Object[20];
    private int index;
    private static final Object NOT_FOUND = new Object();

    public MessageImpl() {
    }

    public MessageImpl(int initialSize, float factor) {
        super(initialSize, factor);
    }

    public MessageImpl(Message m) {
        super(m);
        if (!(m instanceof MessageImpl)) {
            throw new RuntimeException("Not a MessageImpl! " + m.getClass());
        }
        MessageImpl impl = (MessageImpl)m;
        this.exchange = impl.getExchange();
        this.id = impl.id;
        this.interceptorChain = impl.interceptorChain;
        this.contents = impl.contents;
        this.index = impl.index;
    }

    @Override
    public Collection<Attachment> getAttachments() {
        return CastUtils.cast((Collection)this.get(ATTACHMENTS));
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.put(ATTACHMENTS, attachments);
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Destination getDestination() {
        return this.get(Destination.class);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        LOG.entering("MessageImpl", "getContent");
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            LOG.exiting("MessageImpl", "getContent");
            return (T)this.contents[x + 1];
        }
        LOG.exiting("MessageImpl", "getContent");
        return null;
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        LOG.entering("MessageImpl", "setContent");
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            this.contents[x + 1] = content;
            LOG.exiting("MessageImpl", "setContent");
            return;
        }
        if (this.index >= this.contents.length) {
            Object[] tmp = new Object[this.contents.length + 10];
            System.arraycopy(this.contents, 0, tmp, 0, this.contents.length);
            this.contents = tmp;
        }
        this.contents[this.index] = format;
        this.contents[this.index + 1] = content;
        this.index += 2;
        LOG.exiting("MessageImpl", "setContent");
    }

    @Override
    public <T> void removeContent(Class<T> format) {
        for (int x = 0; x < this.index; x += 2) {
            if (this.contents[x] != format) continue;
            this.index -= 2;
            if (x != this.index) {
                this.contents[x] = this.contents[this.index];
                this.contents[x + 1] = this.contents[this.index + 1];
            }
            this.contents[this.index] = null;
            this.contents[this.index + 1] = null;
            return;
        }
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        HashSet c = new HashSet();
        for (int x = 0; x < this.index; x += 2) {
            c.add((Class)this.contents[x]);
        }
        return c;
    }

    public void setDestination(Destination d) {
        this.put(Destination.class, d);
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public Object getContextualProperty(String key) {
        Object o = this.getOrDefault(key, NOT_FOUND);
        if (o != NOT_FOUND) {
            return o;
        }
        return this.getFromExchange(key);
    }

    private Object getFromExchange(String key) {
        Exchange ex = this.getExchange();
        if (ex != null) {
            Service sv;
            Map<String, Object> p;
            Object o = ex.getOrDefault(key, NOT_FOUND);
            if (o != NOT_FOUND) {
                return o;
            }
            Endpoint ep = ex.getEndpoint();
            if (ep != null) {
                o = ep.getOrDefault(key, NOT_FOUND);
                if (o != NOT_FOUND) {
                    return o;
                }
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    p = ei.getProperties();
                    if (p != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                        return o;
                    }
                    p = ei.getBinding().getProperties();
                    if (p != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                        return o;
                    }
                }
            }
            if ((sv = ex.getService()) != null && (o = sv.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                return o;
            }
            Bus b = ex.getBus();
            if (b != null && (p = b.getProperties()) != null && (o = p.getOrDefault(key, NOT_FOUND)) != NOT_FOUND) {
                return o;
            }
        }
        return null;
    }

    private Set<String> getExchangeKeySet() {
        HashSet<String> keys = new HashSet<String>();
        Exchange ex = this.getExchange();
        if (ex != null) {
            Endpoint ep;
            Service sv;
            Map<String, Object> p;
            Bus b = ex.getBus();
            if (b != null && (p = b.getProperties()) != null && !p.isEmpty()) {
                keys.addAll(p.keySet());
            }
            if ((sv = ex.getService()) != null && !sv.isEmpty()) {
                keys.addAll(sv.keySet());
            }
            if ((ep = ex.getEndpoint()) != null) {
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    p = ei.getBinding().getProperties();
                    if (p != null && !p.isEmpty()) {
                        keys.addAll(p.keySet());
                    }
                    if ((p = ei.getProperties()) != null && !p.isEmpty()) {
                        keys.addAll(p.keySet());
                    }
                }
                if (!ep.isEmpty()) {
                    keys.addAll(ep.keySet());
                }
            }
            if (!ex.isEmpty()) {
                keys.addAll(ex.keySet());
            }
        }
        return keys;
    }

    @Override
    public Set<String> getContextualPropertyKeys() {
        Set<String> s = this.getExchangeKeySet();
        s.addAll(this.keySet());
        return s;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
    }

    @Override
    public void resetContextCache() {
    }

    public void setContextualProperty(String key, Object v) {
        if (!this.containsKey(key)) {
            this.put(key, v);
        }
    }
}

