/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public final class CAKeyUpdAnnContent
extends CMPDerObject
implements Cloneable {
    private Certificate oldWithNew;
    private Certificate newWithOld;
    private Certificate newWithNew;

    public CAKeyUpdAnnContent(Certificate certificate, Certificate certificate2, Certificate certificate3) {
        if (certificate == null) {
            throw new IllegalArgumentException("CAKeyUpdAnnContent error, old with new cert not specified");
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("CAKeyUpdAnnContent error, invalid certificate type. Only X509 certificate is supported");
        }
        this.oldWithNew = certificate;
        if (certificate2 == null) {
            throw new IllegalArgumentException("CAKeyUpdAnnContent error, new with old cert not specified");
        }
        if (!(certificate2 instanceof X509Certificate)) {
            throw new IllegalArgumentException("CAKeyUpdAnnContent error, invalid certificate type. Only X509 certificate is supported");
        }
        this.newWithOld = certificate2;
        if (certificate3 == null) {
            throw new IllegalArgumentException("CAKeyUpAnnContent error, new with new cert not specified");
        }
        if (!(certificate3 instanceof X509Certificate)) {
            throw new IllegalArgumentException("CAKeyUpdAnnContent error, invalid certificate type. Only X509 certificate is supported");
        }
        this.newWithNew = certificate3;
    }

    public CAKeyUpdAnnContent(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CAKeyUpdAnnContent(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("CAKeyUpdAnnContent parsing error, not a SEQUENCE");
        }
        this.oldWithNew = null;
        this.newWithOld = null;
        this.newWithNew = null;
        try {
            if (derValue.getData().available() == 0) {
                throw new IOException("CAKeyUpdAnnContent parsing error, missing data");
            }
            this.oldWithNew = new X509CertImpl(derValue.getData().getDerValue());
            if (derValue.getData().available() == 0) {
                throw new IOException("CAKeyUpdAnnContent parsing error, missing data");
            }
            this.newWithOld = new X509CertImpl(derValue.getData().getDerValue());
            if (derValue.getData().available() == 0) {
                throw new IOException("CAKeyUpdAnnContent parsing error, missing data");
            }
            this.newWithNew = new X509CertImpl(derValue.getData().getDerValue());
        }
        catch (CertificateException certificateException) {
            throw new IOException("CAKeyUpdAnnContent decoding error, " + certificateException);
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("CAKeyUpdAnnContent error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        try {
            if (this.oldWithNew == null) {
                throw new IOException("CAKeyUpdAnnContent encoding error, old-with-new certificate not specified");
            }
            derOutputStream.write(this.oldWithNew.getEncoded());
            if (this.newWithOld == null) {
                throw new IOException("CAKeyUpdAnnContent encoding error, new-with-old certificate not specified");
            }
            derOutputStream.write(this.newWithOld.getEncoded());
            if (this.newWithNew == null) {
                throw new IOException("CAKeyUpdAnnContent encoding error, new-with-new certificate not specified");
            }
            derOutputStream.write(this.newWithNew.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new IOException("CAKeyUpdAnnCotent encoding error, " + certificateException);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CAKeyUpdAnnContent cAKeyUpdAnnContent) {
        DerValue derValue;
        DerValue derValue2;
        if (cAKeyUpdAnnContent == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            cAKeyUpdAnnContent.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CAKeyUpdAnnContent) {
            return this.equals((CAKeyUpdAnnContent)object);
        }
        return false;
    }

    public Certificate getNewWithNewCert() {
        try {
            byte[] byArray = this.newWithNew.getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public Certificate getNewWithOldCert() {
        try {
            byte[] byArray = this.newWithOld.getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public Certificate getOldWithNewCert() {
        try {
            byte[] byArray = this.oldWithNew.getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public String toString() {
        String string = "CAKeyUpdateAnnContent:";
        string = String.valueOf(string) + "\r\n\tOldWithNew: " + this.oldWithNew.toString();
        string = String.valueOf(string) + "\r\n\tNewWithOld: " + this.newWithOld.toString();
        string = String.valueOf(string) + "\r\n\tNewWithNew: " + this.newWithNew.toString();
        return string;
    }
}

