/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Vector;

public final class CRLAnnContent
extends CMPDerObject {
    private CRL[] crls;

    public CRLAnnContent(byte[] byArray) throws IOException {
        super(byArray);
    }

    public CRLAnnContent(CRL[] cRLArray) {
        if (cRLArray == null) {
            throw new IllegalArgumentException("CRLAnnContent error, crls not specified");
        }
        int n2 = 0;
        while (n2 < cRLArray.length) {
            if (!(cRLArray[n2] instanceof X509CRL)) {
                throw new IllegalArgumentException("CRLAnnContent error, invalid CRL type for crl[" + n2 + "]. Only X509 CRL is supported");
            }
            ++n2;
        }
        this.crls = cRLArray;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new PKIHeader(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        Vector<X509CRLImpl> vector = new Vector<X509CRLImpl>();
        if (derValue.getTag() != 48) {
            throw new IOException("CRLAnnContent parsing error, not a SEQUENCE OF");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("CRLAnnContent parsing error, missing data");
        }
        try {
            while (derValue.getData().available() != 0) {
                DerValue derValue2 = derValue.getData().getDerValue();
                X509CRLImpl x509CRLImpl = new X509CRLImpl(derValue2);
                vector.add(x509CRLImpl);
            }
        }
        catch (CRLException cRLException) {
            throw new IOException("CRL decoding error, " + cRLException);
        }
        if (vector.size() > 0) {
            this.crls = new X509CRLImpl[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                this.crls[n2] = (X509CRLImpl)vector.elementAt(n2);
                ++n2;
            }
        } else {
            throw new IOException("CRLAnnContent parsing error, missing data");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.crls == null) {
            throw new IOException("CRLAnnContent encoding error, crl list not specified");
        }
        try {
            if (this.crls != null && this.crls.length != 0) {
                int n2 = 0;
                while (n2 < this.crls.length) {
                    if (!(this.crls[n2] instanceof X509CRL)) {
                        throw new IOException("crls[" + n2 + "] has a type of " + this.crls[n2].getClass().getName() + ". Only instances of java.security.cert.X509CRL are supported");
                    }
                    derOutputStream.write(((X509CRL)this.crls[n2]).getEncoded());
                    ++n2;
                }
            }
        }
        catch (CRLException cRLException) {
            throw new IOException(cRLException.toString());
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CRLAnnContent cRLAnnContent) {
        DerValue derValue;
        DerValue derValue2;
        if (cRLAnnContent == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            cRLAnnContent.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CRLAnnContent) {
            return this.equals((CRLAnnContent)object);
        }
        return false;
    }

    public CRL[] getCRLs() {
        return (CRL[])this.crls.clone();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "CRLAnnContent:\r\n";
        if (this.crls == null || this.crls.length == 0) {
            string = String.valueOf(string) + "No certificateLists";
        } else {
            int n2 = 0;
            while (n2 < this.crls.length) {
                string = String.valueOf(string) + "CertificateList[" + n2 + "]\r\n";
                string = String.valueOf(string) + this.crls[n2].toString();
                string = String.valueOf(string) + "\r\n";
                ++n2;
            }
        }
        return string;
    }
}

