/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CertId;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Vector;

public final class RevRepContent
extends CMPDerObject {
    private PKIStatusInfo[] status;
    private CertId[] revCerts;
    private CRL[] crls;
    private static final byte TAG_REV_CERTS = 0;
    private static final byte TAG_CRLS = 1;

    public RevRepContent(byte[] byArray) throws IOException {
        super(byArray);
    }

    public RevRepContent(PKIStatusInfo[] pKIStatusInfoArray, CertId[] certIdArray, CRL[] cRLArray) {
        if (pKIStatusInfoArray == null) {
            throw new IllegalArgumentException("RevRepContent error, statusInfos not specified");
        }
        if (pKIStatusInfoArray.length == 0) {
            throw new IllegalArgumentException("RevRepContent error, empty statusInfos");
        }
        this.status = pKIStatusInfoArray;
        this.revCerts = certIdArray;
        if (cRLArray != null) {
            int n2 = 0;
            while (n2 < cRLArray.length) {
                if (!(cRLArray[n2] instanceof X509CRL)) {
                    throw new IllegalArgumentException("RevRepContent error, invalid CRL type for crl[" + n2 + "]. Only X509 CRL is supported");
                }
                ++n2;
            }
            this.crls = cRLArray;
        } else {
            this.crls = null;
        }
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new RevRepContent(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        block17: {
            block16: {
                if (var1_1.getTag() != 48) {
                    throw new IOException("RevRepContent parsing error, not a SEQUENCE");
                }
                if (var1_1.getData().available() == 0) {
                    throw new IOException("RevRepContent parsing error, not enough data");
                }
                this.status = null;
                this.revCerts = null;
                this.crls = null;
                var2_2 = var1_1.getData().getDerValue();
                var3_3 = new Vector<PKIStatusInfo>();
                if (var2_2.getTag() == 48) ** GOTO lbl16
                throw new IOException("RevRepContent parsing error, not a SEQUENCE OF");
lbl-1000:
                // 1 sources

                {
                    var4_4 = var2_2.getData().getDerValue();
                    var5_6 = new PKIStatusInfo(var4_4.toByteArray());
                    var3_3.add((PKIStatusInfo)var5_6);
lbl16:
                    // 2 sources

                    ** while (var2_2.getData().available() != 0)
                }
lbl17:
                // 1 sources

                if (var3_3.size() > 0) {
                    this.status = new PKIStatusInfo[var3_3.size()];
                    var4_5 = 0;
                    while (var4_5 < var3_3.size()) {
                        this.status[var4_5] = (PKIStatusInfo)var3_3.elementAt(var4_5);
                        ++var4_5;
                    }
                }
                if (var1_1.getData().available() == 0) {
                    return;
                }
                var2_2 = var1_1.getData().getDerValue();
                if (!var2_2.isContextSpecific((byte)0) || !var2_2.isConstructed()) break block16;
                var4_4 = new Vector<E>();
                if ((var2_2 = var2_2.getData().getDerValue()).getTag() == 48) ** GOTO lbl35
                throw new IOException("RevRepContent parsing error, not a SEQUENCE OF -a");
lbl-1000:
                // 1 sources

                {
                    var5_6 = var2_2.getData().getDerValue();
                    var6_9 = new CertId(var5_6.toByteArray());
                    var4_4.add(var6_9);
lbl35:
                    // 2 sources

                    ** while (var2_2.getData().available() != 0)
                }
lbl36:
                // 1 sources

                if (var4_4.size() > 0) {
                    this.revCerts = new CertId[var4_4.size()];
                    var5_7 = 0;
                    while (var5_7 < var4_4.size()) {
                        this.revCerts[var5_7] = (CertId)var4_4.elementAt(var5_7);
                        ++var5_7;
                    }
                }
                if (var1_1.getData().available() == 0) {
                    return;
                }
                var2_2 = var1_1.getData().getDerValue();
            }
            if (!var2_2.isContextSpecific((byte)1) || !var2_2.isConstructed()) break block17;
            var4_4 = new Vector<Object>();
            if ((var2_2 = var2_2.getData().getDerValue()).getTag() == 48) ** GOTO lbl59
            throw new IOException("RevRepContent parsing error, not a SEQUENCE OF -b");
lbl-1000:
            // 1 sources

            {
                var5_6 = var2_2.getData().getDerValue();
                try {
                    var6_9 = new X509CRLImpl((DerValue)var5_6);
                    var4_4.add(var6_9);
                    continue;
                }
                catch (CRLException var6_10) {
                    throw new IOException("RevRepContent parsing error, " + var6_10);
                }
lbl59:
                // 2 sources

                ** while (var2_2.getData().available() != 0)
            }
lbl60:
            // 1 sources

            if (var4_4.size() > 0) {
                this.crls = new X509CRLImpl[var4_4.size()];
                var5_8 = 0;
                while (var5_8 < var4_4.size()) {
                    this.crls[var5_8] = (X509CRLImpl)var4_4.elementAt(var5_8);
                    ++var5_8;
                }
            }
            if (var1_1.getData().available() == 0) {
                return;
            }
        }
        throw new IOException("RevRepContent parsing error, extra data");
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n2;
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.status == null) {
            throw new IOException("RevRepContent encoding error, status not specified");
        }
        DerOutputStream derOutputStream4 = new DerOutputStream();
        int n3 = 0;
        while (n3 < this.status.length) {
            this.status[n3].encode(derOutputStream4);
            ++n3;
        }
        derOutputStream2.write((byte)48, derOutputStream4);
        if (this.revCerts != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream4 = new DerOutputStream();
            n2 = 0;
            while (n2 < this.revCerts.length) {
                this.revCerts[n2].encode(derOutputStream);
                ++n2;
            }
            derOutputStream4.write((byte)48, derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
        }
        if (this.crls != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream4 = new DerOutputStream();
            n2 = 0;
            while (n2 < this.crls.length) {
                try {
                    derOutputStream.write(((X509CRL)this.crls[n2]).getEncoded());
                }
                catch (CRLException cRLException) {
                    throw new IOException("Error encoding X.509 CRL.");
                }
                ++n2;
            }
            derOutputStream4.write((byte)48, derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream4);
        }
        derOutputStream3.write((byte)48, derOutputStream2);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public boolean equals(RevRepContent revRepContent) {
        DerValue derValue;
        DerValue derValue2;
        if (revRepContent == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            revRepContent.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof RevRepContent) {
            return this.equals((RevRepContent)object);
        }
        return false;
    }

    public CRL[] getCRLs() {
        if (this.crls == null) {
            return null;
        }
        return (CRL[])this.crls.clone();
    }

    public CertId[] getRevokedCerts() {
        if (this.revCerts == null) {
            return null;
        }
        return (CertId[])this.revCerts.clone();
    }

    public PKIStatusInfo[] getStatus() {
        return (PKIStatusInfo[])this.status.clone();
    }

    public String toString() {
        int n2;
        String string = "RevRepContent:";
        int n3 = 0;
        while (n3 < this.status.length) {
            string = String.valueOf(string) + "\r\n\tstatus[" + n3 + "]: " + this.status[n3];
            ++n3;
        }
        if (this.revCerts == null || this.revCerts.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo revoked certs ";
        } else {
            n2 = 0;
            while (n2 < this.revCerts.length) {
                string = String.valueOf(string) + "\r\n\trevCert[" + n2 + "]: " + this.revCerts[n2];
                ++n2;
            }
        }
        if (this.crls == null || this.crls.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo CRLs ";
        } else {
            n2 = 0;
            while (n2 < this.crls.length) {
                string = String.valueOf(string) + "\r\n\tCRLS[" + n2 + "]: " + this.crls[n2];
                ++n2;
            }
        }
        return string;
    }
}

