/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.AttributeTypeAndValue;
import com.ibm.security.crmf.RegCtrl;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class RegistrationControl
extends CMPDerObject
implements AttributeTypeAndValue {
    private RegCtrl regCtrl;
    private ObjectIdentifier oid;
    private Object value;
    private byte[] encodedValue;

    public RegistrationControl(RegCtrl regCtrl) throws IOException {
        if (regCtrl == null) {
            throw new IllegalArgumentException("RegistrationControl error, regCtrl not specified");
        }
        this.regCtrl = regCtrl;
        this.oid = regCtrl.getObjectIdentifier();
        this.value = regCtrl.getValue();
        if (this.value == null) {
            this.encodedValue = null;
        } else {
            DerOutputStream derOutputStream = new DerOutputStream();
            CMPDerObject cMPDerObject = (CMPDerObject)((Object)regCtrl);
            cMPDerObject.encode(derOutputStream);
            byte[] byArray = derOutputStream.toByteArray();
            this.encodedValue = byArray;
        }
    }

    public RegistrationControl(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new RegistrationControl(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("RegistrationControl parsing error, not a SEQUENCE");
        }
        this.oid = derValue.getData().getOID();
        if (derValue.getData().available() == 0) {
            this.value = null;
            this.encodedValue = null;
            this.regCtrl = null;
            return;
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.encodedValue = derValue2.toByteArray();
        if (derValue.getData().available() != 0) {
            throw new IOException("RegistrationControl parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        if (this.encodedValue != null) {
            derOutputStream.write(this.encodedValue);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(RegistrationControl registrationControl) {
        DerValue derValue;
        DerValue derValue2;
        if (registrationControl == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            registrationControl.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof RegistrationControl) {
            return this.equals((RegistrationControl)object);
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    public byte[] getValue() {
        if (this.encodedValue == null) {
            return null;
        }
        return (byte[])this.encodedValue.clone();
    }

    public String toString() {
        String string = "";
        if (this.regCtrl != null) {
            string = String.valueOf(string) + this.regCtrl.toString();
        } else {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            string = String.valueOf(string) + "\r\nobject identifier: " + this.oid.toString();
            string = String.valueOf(string) + "\r\nvalue:";
            string = String.valueOf(string) + "\r\n";
            string = this.encodedValue != null ? String.valueOf(string) + hexDumpEncoder.encode(this.encodedValue) : String.valueOf(string) + "null";
        }
        return string;
    }
}

