/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Arrays;

public final class CrlBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid;
    private Object value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.CrlBag";
    private volatile int cachedHashVal = 0;

    public CrlBag(CRL crl) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CrlBag", crl);
        }
        if (!(crl instanceof X509CRL)) {
            if (debug != null) {
                debug.text(16384L, className, "CrlBag", "Input CRL must extend X509CRL.");
            }
            throw new IllegalArgumentException("Input CRL must extend X509CRL.");
        }
        this.oid = PKCSOID.X509_CRL_OID;
        this.value = crl;
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(CRL crl, String provider) throws PKCSException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", crl, provider);
        }
        if (!(crl instanceof X509CRL)) {
            if (debug != null) {
                debug.text(16384L, className, "CrlBag", "Input CRL must extend X509CRL.");
            }
            throw new IllegalArgumentException("Input CRL must extend X509CRL.");
        }
        this.oid = PKCSOID.X509_CRL_OID;
        this.value = crl;
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(ObjectIdentifier oid, byte[] encoding) {
        this(oid, encoding, null);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", oid, encoding);
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(ObjectIdentifier oid, byte[] encoding, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{oid, encoding, provider};
            debug.entry(16384L, (Object)className, "CrlBag", parms);
        }
        if (!oid.equals(PKCSOID.X509CRLBAG_OID) && !oid.equals(PKCSOID.X509_CRL_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "CrlBag", "Invalid input object identifier.");
            }
            throw new IllegalArgumentException("Invalid input object identifier.");
        }
        try {
            this.value = new X509CRLImpl(encoding);
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "CrlBag", e2);
            }
            throw new IllegalArgumentException("Invalid CRL encoding.");
        }
        this.oid = oid;
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CrlBag", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "CrlBag", filename, new Boolean(base64));
            debug.exit(16384L, className, "CrlBag");
        }
    }

    public CrlBag(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "CrlBag", parms);
            debug.exit(16384L, className, "CrlBag");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        bytes.putOID(this.oid);
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        X509CRL crl = (X509CRL)this.value;
        try {
            tmpout.write(crl.getEncoded());
            tmpout2.putOctetString(tmpout.toByteArray());
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), tmpout2);
        }
        catch (CRLException e2) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding X.509 CRL.");
            }
            throw new IOException("Error encoding X.509 CRL.");
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier myoid = null;
        try {
            myoid = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception e2) {
            myoid = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", myoid);
        }
        return myoid;
    }

    @Override
    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        try {
            X509CRLImpl retval = new X509CRLImpl(this.getEncodedValue());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getValue_1", retval);
            }
            return retval;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", e2);
                debug.exit(16384L, (Object)className, "getValue_2", null);
            }
            return null;
        }
    }

    @Override
    public byte[] getEncodedValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        X509CRL crl = (X509CRL)this.value;
        try {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_1", crl.getEncoded());
            }
            return crl.getEncoded();
        }
        catch (CRLException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", e2);
                debug.exit(16384L, (Object)className, "getEncodedValue_2", null);
            }
            return null;
        }
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "CrlBag");
        }
        return "CrlBag";
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof CrlBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((CrlBag)other));
            }
            return this.equals((CrlBag)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            CrlBag retobj = new CrlBag(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public String toString() {
        Object obj = this.getValue();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "CrlBag:";
        out = out + "\r\nobject identifier: " + this.oid;
        out = out + "\r\ncertificate revocation list:\r\n";
        out = out + obj.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CrlBag parsing error, not a SEQUENCE.");
            }
            throw new IOException("CrlBag parsing error, not a SEQUENCE.");
        }
        this.oid = encoding.getData().getOID();
        if (!this.oid.equals(PKCSOID.X509CRLBAG_OID) && !this.oid.equals(PKCSOID.X509_CRL_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid CrlBag object identifier in encoding.");
            }
            throw new IllegalArgumentException("Invalid CrlBag object identifier in encoding.");
        }
        DerValue tmpDer = encoding.getData().getDerValue();
        DerValue der = tmpDer.isContextSpecific((byte)0) ? tmpDer.getData().getDerValue() : tmpDer;
        if (this.oid.equals(PKCSOID.X509CRLBAG_OID) || this.oid.equals(PKCSOID.X509_CRL_OID)) {
            try {
                byte[] enc = der.getOctetString();
                this.value = new X509CRLImpl(enc);
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", e2);
                }
                throw new IOException("Error decoding X.509 CRL.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoded OID");
            }
            throw new IllegalArgumentException("Invalid encoded OID");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(CrlBag other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e2);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

