/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.util.Vector;

public final class CertificatePolicySet {
    private Vector<CertificatePolicyId> ids;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificatePolicySet";

    public CertificatePolicySet(Vector<CertificatePolicyId> ids) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePolicySet", ids);
            debug.exit(16384L, className, "CertificatePolicySet");
        }
        this.ids = ids;
    }

    public CertificatePolicySet(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePolicySet", in);
        }
        this.ids = new Vector();
        DerValue[] seq = in.getSequence(5);
        for (int i2 = 0; i2 < seq.length; ++i2) {
            CertificatePolicyId id = new CertificatePolicyId(seq[i2]);
            this.ids.addElement(id);
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePolicySet");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s2 = "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s2);
        }
        return s2;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        for (int i2 = 0; i2 < this.ids.size(); ++i2) {
            this.ids.elementAt(i2).encode(tmp);
        }
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }
}

