/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.beans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.cdi.beans.Utils;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.BasicAuthenticationCredential;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;

@Default
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BasicHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    ModulePropertiesProvider mpp = null;
    private static final TraceComponent tc = Tr.register(BasicHttpAuthenticationMechanism.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    private String realmName = "";
    private final Utils utils;
    static final long serialVersionUID = -2039149947710141941L;

    public BasicHttpAuthenticationMechanism() {
        this.utils = new Utils();
    }

    protected BasicHttpAuthenticationMechanism(Utils utils) {
        this.utils = utils;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        if (httpMessageContext.getRequest().getUserPrincipal() != null) {
            httpMessageContext.getResponse().setStatus(200);
            return AuthenticationStatus.SUCCESS;
        }
        this.setRealmName();
        Subject clientSubject = httpMessageContext.getClientSubject();
        AuthenticationParameters authParams = httpMessageContext.getAuthParameters();
        Credential cred = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AuthenticationParameters : " + authParams), (Object[])new Object[0]);
        }
        if (authParams != null) {
            cred = authParams.getCredential();
        }
        if (cred != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Credential is found.", (Object[])new Object[0]);
            }
            status = this.utils.handleAuthenticate(this.getCDI(), this.realmName, cred, clientSubject, httpMessageContext);
        } else {
            String authHeader = httpMessageContext.getRequest().getHeader("Authorization");
            status = authHeader == null ? this.handleNoAuthorizationHeader(httpMessageContext) : this.handleAuthorizationHeader(authHeader, clientSubject, httpMessageContext);
        }
        return status;
    }

    private void setRealmName() {
        Properties props;
        this.mpp = this.getModulePropertiesProvider();
        if (this.mpp != null && (props = this.mpp.getAuthMechProperties(BasicHttpAuthenticationMechanism.class)) != null) {
            this.realmName = (String)props.get("realmName");
        }
    }

    private AuthenticationStatus handleNoAuthorizationHeader(HttpMessageContext httpMessageContext) {
        AuthenticationStatus status;
        if (!httpMessageContext.isAuthenticationRequest() && !httpMessageContext.isProtected()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"both isAuthenticationRequest and isProtected returns false. returing NOT_DONE,", (Object[])new Object[0]);
            }
            status = AuthenticationStatus.NOT_DONE;
        } else {
            status = this.setChallengeAuthorizationHeader(httpMessageContext);
        }
        return status;
    }

    private AuthenticationStatus setChallengeAuthorizationHeader(HttpMessageContext httpMessageContext) {
        HttpServletResponse rsp = httpMessageContext.getResponse();
        rsp.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        rsp.setStatus(401);
        httpMessageContext.getMessageInfo().getMap().put("com.ibm.wsspi.security.cred.realm", this.realmName);
        return AuthenticationStatus.SEND_CONTINUE;
    }

    private AuthenticationStatus handleAuthorizationHeader(@Sensitive String authorizationHeader, Subject clientSubject, HttpMessageContext httpMessageContext) throws AuthenticationException {
        String encodedHeader;
        String basicAuthHeader;
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        int rspStatus = 401;
        if (authorizationHeader.startsWith("Basic ") && this.isAuthorizationHeaderValid(basicAuthHeader = this.decodeCookieString(encodedHeader = authorizationHeader.substring(6)))) {
            BasicAuthenticationCredential basicAuthCredential = new BasicAuthenticationCredential(encodedHeader);
            UsernamePasswordCredential userPassCredential = new UsernamePasswordCredential(basicAuthCredential.getCaller(), basicAuthCredential.getPasswordAsString());
            status = this.utils.validateUserAndPassword(this.getCDI(), this.realmName, clientSubject, userPassCredential, httpMessageContext);
            if (status == AuthenticationStatus.SUCCESS) {
                Map messageInfoMap = httpMessageContext.getMessageInfo().getMap();
                messageInfoMap.put("jakarta.servlet.http.authType", "BASIC");
                messageInfoMap.put("jakarta.servlet.http.registerSession", Boolean.TRUE.toString());
                rspStatus = 200;
            } else if (status == AuthenticationStatus.NOT_DONE) {
                rspStatus = 200;
            }
        }
        httpMessageContext.getResponse().setStatus(rspStatus);
        return status;
    }

    @Sensitive
    private String decodeCookieString(@Sensitive String cookieString) {
        try {
            return Base64Coder.base64Decode((String)cookieString);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.cdi.beans.BasicHttpAuthenticationMechanism", (String)"165", (Object)this, (Object[])objectArray);
            return null;
        }
    }

    private boolean isAuthorizationHeaderValid(@Sensitive String basicAuthHeader) {
        int index = -1;
        boolean isNotValid = basicAuthHeader == null || basicAuthHeader.isEmpty() || (index = basicAuthHeader.indexOf(58)) <= 0 || index == basicAuthHeader.length() - 1;
        return !isNotValid;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    protected CDI getCDI() {
        try {
            return CDI.current();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    protected ModulePropertiesProvider getModulePropertiesProvider() {
        Instance modulePropertiesProivderInstance = this.getCDI().select(ModulePropertiesProvider.class, new Annotation[0]);
        if (modulePropertiesProivderInstance != null) {
            return (ModulePropertiesProvider)modulePropertiesProivderInstance.get();
        }
        return null;
    }

    protected void setMPP(ModulePropertiesProvider mpp) {
        this.mpp = mpp;
    }
}

