/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.beans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import com.ibm.ws.security.javaeesec.cdi.beans.CustomFormAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.cdi.beans.FormAuthenticationMechanism;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesProvider;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfigurationImpl;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfigurationImpl;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.el.ELProcessor;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.credential.Credential;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;

@LoginToContinue
@Interceptor
@Priority(value=220)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LoginToContinueInterceptor {
    private static final String ATTR_DONE_LOGIN_PROCESS = "com.ibm.ws.security.javaeesec.donePostLoginProcess";
    private static final String METHOD_TO_INTERCEPT = "validateRequest";
    private static final TraceComponent tc = Tr.register(LoginToContinueInterceptor.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    ModulePropertiesProvider mpp = null;
    private final boolean resolved = false;
    Properties props = null;
    private String _errorPage = null;
    private String _loginPage = null;
    private Boolean _isForward = null;
    private Boolean _useGlobalLogin = false;
    private String _formLoginContextRoot = null;
    private boolean isCustomHAM = false;
    static final long serialVersionUID = -6016370731621679946L;

    @PostConstruct
    public void initialize(InvocationContext ic) {
        this.mpp = this.getModulePropertiesProvider();
        if (this.mpp != null) {
            Class hamClass = this.getTargetClass(ic);
            this.isCustomHAM = this.isCustomHAM(hamClass);
            this.props = this.mpp.getAuthMechProperties(hamClass);
            this._isForward = this.resolveBoolean((String)this.props.get("useForwardToLoginExpression"), (Boolean)this.props.get("useForwardToLogin"), true, this.isCustomHAM);
            this._loginPage = this.resolveString((String)this.props.get("loginPage"), "/login", true, this.isCustomHAM);
            this._errorPage = this.resolveString((String)this.props.get("errorPage"), "/login-error", true, this.isCustomHAM);
            this._useGlobalLogin = (Boolean)this.props.get("useGlobalLogin");
            this._formLoginContextRoot = (String)this.props.get("formLoginContextRoot");
            if (this._useGlobalLogin == null) {
                this._useGlobalLogin = Boolean.FALSE;
            }
            if (this._formLoginContextRoot == null) {
                this._formLoginContextRoot = "";
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_LOGIN_TO_CONTINUE_DOES_NOT_EXIST", (Object[])new Object[0]);
        }
    }

    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        Object result = null;
        if (this.isMethodToIntercept(ic)) {
            if (this.mpp != null) {
                Object[] params = ic.getParameters();
                HttpServletRequest req = (HttpServletRequest)params[0];
                HttpServletResponse res = (HttpServletResponse)params[1];
                HttpMessageContext hmc = (HttpMessageContext)params[2];
                if (this.isNewAuth(hmc)) {
                    return ic.proceed();
                }
                if (this.isJSecurityCheck(req) || this.existCredential(hmc)) {
                    result = ic.proceed();
                    if (AuthenticationStatus.SUCCESS.equals(result)) {
                        this.postLoginProcess(req, res);
                    } else if (AuthenticationStatus.SEND_FAILURE.equals(result)) {
                        this.redirectErrorPage(this.mpp.getAuthMechProperties(this.getClass(ic)), req, res);
                    }
                    return result;
                }
                if (hmc.getRequest().getUserPrincipal() != null) {
                    if (this.existsCookie(req, "WASReqURL")) {
                        this.removeWasReqUrlCookie(req, res);
                        return AuthenticationStatus.SUCCESS;
                    }
                    if (!this.isCustomHAM) {
                        return AuthenticationStatus.SUCCESS;
                    }
                }
                if (this.isInitialProtectedUrl(hmc)) {
                    return this.gotoLoginPage(this.mpp.getAuthMechProperties(this.getClass(ic)), req, res, hmc);
                }
                return ic.proceed();
            }
            Tr.error((TraceComponent)tc, (String)"JAVAEESEC_CDI_ERROR_LOGIN_TO_CONTINUE_DOES_NOT_EXIST", (Object[])new Object[0]);
            result = AuthenticationStatus.SEND_FAILURE;
        } else {
            result = ic.proceed();
        }
        return result;
    }

    private boolean isJSecurityCheck(HttpServletRequest req) {
        return req.getRequestURI().contains("/j_security_check");
    }

    private boolean existCredential(HttpMessageContext hmc) {
        Credential cred;
        AuthenticationParameters authParams = hmc.getAuthParameters();
        return authParams != null && (cred = authParams.getCredential()) != null;
    }

    private boolean isInitialProtectedUrl(HttpMessageContext hmc) {
        return hmc.isProtected();
    }

    private boolean existsCookie(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        return cookies != null && CookieHelper.getCookieValues((Cookie[])cookies, (String)cookieName) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AuthenticationStatus gotoLoginPage(Properties props, HttpServletRequest req, HttpServletResponse res, HttpMessageContext httpMessageContext) throws IOException {
        String loginPage = this.resolveString((String)props.get("loginPage"), this._loginPage);
        String errorPage = this.resolveString((String)props.get("errorPage"), this._errorPage);
        boolean useForwardToLogin = this.resolveBoolean((String)props.get("useForwardToLoginExpression"), this._isForward);
        AuthenticationStatus status = AuthenticationStatus.SEND_CONTINUE;
        if (!this._useGlobalLogin.booleanValue()) {
            this.updateFormLoginConfiguration(loginPage, errorPage);
        } else {
            this.updateFormLoginConfiguration("", "");
        }
        this.setCookies(req, res);
        if (this._useGlobalLogin.booleanValue() || useForwardToLogin) {
            RequestDispatcher rd;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The request will be forwarded to the login page.", (Object[])new Object[0]);
            }
            if (this._useGlobalLogin.booleanValue()) {
                ServletContext ctx = req.getServletContext().getContext(this._formLoginContextRoot);
                if (ctx == null) throw new IllegalArgumentException("The context root " + this._formLoginContextRoot + " is not valid. Please make sure that the attribute contextRootForFormAuthenticationMechanism is set properly, and the form login page which is specified by the attribute loginFormURL is valid.");
                rd = ctx.getRequestDispatcher(loginPage);
            } else {
                rd = req.getRequestDispatcher(loginPage);
            }
            try {
                if (req.getMethod().equalsIgnoreCase("POST") && req instanceof IExtendedRequest) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Set GET method instead of original POST method for preventing a potential JSF error.", (Object[])new Object[0]);
                    }
                    ((IExtendedRequest)req).setMethod("GET");
                }
                rd.forward((ServletRequest)req, (ServletResponse)res);
                return status;
            }
            catch (Exception ctx) {
                FFDCFilter.processException((Throwable)ctx, (String)"com.ibm.ws.security.javaeesec.cdi.beans.LoginToContinueInterceptor", (String)"239", (Object)this, (Object[])new Object[]{props, req, res, httpMessageContext});
                return AuthenticationStatus.SEND_FAILURE;
            }
        } else {
            res.setStatus(302);
            res.sendRedirect(res.encodeURL(this.getUrl(req, loginPage, false)));
        }
        return status;
    }

    private Boolean resolveBoolean(String expression, Boolean value, boolean isImmediateOnly, boolean isCustomHAM) {
        Boolean result = null;
        if (expression != null && !expression.isEmpty()) {
            if (!isCustomHAM && ModulePropertiesUtils.getInstance().isImmediateEval(expression) && isImmediateOnly) {
                result = this.resolveBoolean(expression);
            }
        } else {
            result = value != null ? value : Boolean.TRUE;
        }
        return result;
    }

    private Boolean resolveBoolean(String expression, Boolean value) {
        if (value != null) {
            return (boolean)value;
        }
        return this.resolveBoolean(expression);
    }

    protected Boolean resolveBoolean(String expression) {
        Boolean result = Boolean.TRUE;
        if (expression != null && !expression.isEmpty()) {
            ELProcessor elProcessor = this.getELProcessorWithAppModuleBeanManagerELResolver();
            String value = ModulePropertiesUtils.getInstance().extractExpression(expression);
            result = (Boolean)elProcessor.eval(value);
        }
        return result;
    }

    private String resolveString(String expression, String defaultValue, boolean isImmediateOnly, boolean isCustomHAM) {
        String result = null;
        if (ModulePropertiesUtils.getInstance().isELExpression(expression)) {
            if (!isCustomHAM && ModulePropertiesUtils.getInstance().isImmediateEval(expression) && isImmediateOnly) {
                result = this.resolveString(expression);
            }
        } else {
            result = expression != null ? expression : defaultValue;
        }
        return result;
    }

    private String resolveString(String expression, String value) {
        if (value != null) {
            return value;
        }
        return this.resolveString(expression);
    }

    protected String resolveString(String expression) {
        String result = null;
        if (expression != null && !expression.isEmpty()) {
            ELProcessor elProcessor = this.getELProcessorWithAppModuleBeanManagerELResolver();
            String value = ModulePropertiesUtils.getInstance().extractExpression(expression);
            result = (String)elProcessor.eval(value);
        }
        return result;
    }

    private void updateFormLoginConfiguration(String loginPage, String errorPage) {
        if (loginPage != null && errorPage != null) {
            FormLoginConfigurationImpl flc = new FormLoginConfigurationImpl(loginPage, errorPage);
            LoginConfigurationImpl lc = new LoginConfigurationImpl("FORM", null, (FormLoginConfiguration)flc);
            SecurityMetadata smd = this.getSecurityMetadata();
            if (smd != null) {
                smd.setLoginConfiguration((LoginConfiguration)lc);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("LoginConfiguration was updated. " + lc), (Object[])new Object[0]);
                }
            }
        }
    }

    protected SecurityMetadata getSecurityMetadata() {
        return WebConfigUtils.getSecurityMetadata();
    }

    protected void postLoginProcess(HttpServletRequest req, HttpServletResponse res) throws IOException, RuntimeException {
        String storedReq = null;
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        ReferrerURLCookieHandler referrerURLHandler = webAppSecConfig.createReferrerURLCookieHandler();
        storedReq = this.getStoredReq(req, referrerURLHandler);
        if (storedReq != null && storedReq.length() > 0) {
            ReferrerURLCookieHandler.isReferrerHostValid((String)PasswordNullifier.nullifyParams((String)req.getRequestURL().toString()), (String)PasswordNullifier.nullifyParams((String)storedReq), (List)webAppSecConfig.getWASReqURLRedirectDomainNames());
        }
        if (!req.getRequestURL().equals(storedReq)) {
            res.setHeader("Location", res.encodeURL(storedReq));
            res.setStatus(302);
        } else {
            res.setStatus(200);
        }
        req.setAttribute(ATTR_DONE_LOGIN_PROCESS, (Object)Boolean.TRUE);
    }

    protected void redirectErrorPage(Properties props, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String errorPage = this.resolveString((String)props.get("errorPage"), this._errorPage);
        if (errorPage != null && !errorPage.isEmpty()) {
            res.sendRedirect(res.encodeURL(this.getUrl(req, errorPage, this._useGlobalLogin)));
        }
        req.setAttribute(ATTR_DONE_LOGIN_PROCESS, (Object)Boolean.TRUE);
    }

    protected void removeWasReqUrlCookie(HttpServletRequest req, HttpServletResponse res) throws IOException, RuntimeException {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        ReferrerURLCookieHandler referrerURLHandler = webAppSecConfig.createReferrerURLCookieHandler();
        referrerURLHandler.invalidateReferrerURLCookie(req, res, "WASReqURL");
    }

    @Sensitive
    private String getStoredReq(HttpServletRequest req, ReferrerURLCookieHandler referrerURLHandler) {
        String storedReq = referrerURLHandler.getReferrerURLFromCookies(req, "WASReqURL");
        if (storedReq != null) {
            if (storedReq.equals("/")) {
                storedReq = "";
            } else if (storedReq.startsWith("/")) {
                storedReq = storedReq.substring(1);
            }
        } else {
            storedReq = "";
        }
        return storedReq;
    }

    private void setCookies(HttpServletRequest req, HttpServletResponse res) {
        WebAppSecurityConfig webAppSecConfig = this.getWebAppSecurityConfig();
        if (this.allowToAddCookieToResponse(webAppSecConfig, req)) {
            AuthenticationResult authResult = new AuthenticationResult(AuthResult.REDIRECT, "dummy");
            if ("POST".equalsIgnoreCase(req.getMethod())) {
                PostParameterHelper postParameterHelper = new PostParameterHelper(webAppSecConfig);
                postParameterHelper.save(req, res, authResult, true);
            }
            ReferrerURLCookieHandler referrerURLHandler = this.getWebAppSecurityConfig().createReferrerURLCookieHandler();
            String query = req.getQueryString();
            String originalURL = req.getRequestURL().append(query != null ? "?" + query : "").toString();
            referrerURLHandler.setReferrerURLCookie(req, authResult, originalURL);
            List cookies = authResult.getCookies();
            for (Cookie c : cookies) {
                res.addCookie(c);
            }
        }
    }

    private String getUrl(HttpServletRequest req, String uri, boolean appendContextRoot) {
        StringBuilder builder = new StringBuilder(req.getRequestURL());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getURL : uri : " + uri), (Object[])new Object[]{", requestURL : " + builder + ", appendContextRoot : " + appendContextRoot});
        }
        int hostIndex = builder.indexOf("//");
        int contextIndex = builder.indexOf("/", hostIndex + 2);
        String contextPath = appendContextRoot ? this._formLoginContextRoot : req.getContextPath();
        builder.replace(contextIndex, builder.length(), this.normalizeURL(uri, contextPath));
        return builder.toString();
    }

    private String normalizeURL(String url, String contextPath) {
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return contextPath + url;
    }

    private boolean allowToAddCookieToResponse(WebAppSecurityConfig webAppSecConfig, HttpServletRequest req) {
        boolean secureRequest = req.isSecure();
        if (webAppSecConfig.getSSORequiresSSL() && !secureRequest) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSO requires SSL. The cookie will not be sent back because the request is not over https.", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected boolean isMethodToIntercept(InvocationContext ic) {
        String methodName = ic.getMethod().getName();
        return METHOD_TO_INTERCEPT.equals(methodName);
    }

    protected Class getClass(InvocationContext ic) {
        return ic.getMethod().getDeclaringClass();
    }

    protected Class getTargetClass(InvocationContext ic) {
        return ic.getTarget().getClass().getSuperclass();
    }

    protected boolean isCustomHAM(Class className) {
        return !CustomFormAuthenticationMechanism.class.equals((Object)className) && !FormAuthenticationMechanism.class.equals((Object)className);
    }

    protected ModulePropertiesProvider getModulePropertiesProvider() {
        Instance modulePropertiesProivderInstance = this.getCDI().select(ModulePropertiesProvider.class, new Annotation[0]);
        if (modulePropertiesProivderInstance != null) {
            return (ModulePropertiesProvider)modulePropertiesProivderInstance.get();
        }
        return null;
    }

    private boolean isNewAuth(HttpMessageContext hmc) {
        AuthenticationParameters authParams = hmc.getAuthParameters();
        if (authParams != null) {
            return authParams.isNewAuthentication();
        }
        return false;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    protected CDI getCDI() {
        try {
            return CDI.current();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    protected void setMPP(ModulePropertiesProvider mpp) {
        this.mpp = mpp;
    }

    protected WebAppSecurityConfig getWebAppSecurityConfig() {
        return WebConfigUtils.getWebAppSecurityConfig();
    }

    protected ELProcessor getELProcessorWithAppModuleBeanManagerELResolver() {
        return CDIHelper.getELProcessor();
    }

    protected String getErrorPage() {
        return this._errorPage;
    }

    protected String getLoginPage() {
        return this._loginPage;
    }

    protected Boolean getIsForward() {
        return this._isForward;
    }

    protected Boolean getUseGlobalLogin() {
        return this._useGlobalLogin;
    }
}

