/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.javaeesec.properties.ModuleProperties;
import com.ibm.ws.threadContext.ModuleMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpAuthenticationMechanismsTracker {
    private static final TraceComponent tc = Tr.register(HttpAuthenticationMechanismsTracker.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    private final Map<String, Map<String, ModuleProperties>> moduleMapsPerApplication = new HashMap<String, Map<String, ModuleProperties>>();
    static final long serialVersionUID = 6841401720275469327L;

    public void initialize(String applicationName) {
        if (applicationName != null) {
            this.moduleMapsPerApplication.remove(applicationName);
            this.moduleMapsPerApplication.put(applicationName, this.createInitializedWebModuleMap());
        }
    }

    private Map<String, ModuleProperties> createInitializedWebModuleMap() {
        HashMap<String, ModuleProperties> moduleMap = new HashMap<String, ModuleProperties>();
        Map<String, URL> wml = this.getWebModuleMap();
        if (wml != null) {
            for (Map.Entry<String, URL> entry : wml.entrySet()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("moduleName : " + entry.getKey() + ", location : " + entry.getValue()), (Object[])new Object[0]);
                }
                moduleMap.put(entry.getKey(), new ModuleProperties(entry.getValue()));
            }
        }
        return moduleMap;
    }

    private Map<String, URL> getWebModuleMap() {
        Map<URL, ModuleMetaData> mmds = this.getModuleMetaDataMap();
        HashMap<String, URL> map = null;
        if (mmds != null) {
            map = new HashMap<String, URL>();
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData)) continue;
                String j2eeModuleName = mmd.getJ2EEName().getModule();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("j2ee module name  : " + j2eeModuleName), (Object[])new Object[0]);
                }
                map.put(j2eeModuleName, entry.getKey());
            }
        }
        return map;
    }

    public static String getApplicationName() {
        String result = null;
        Map<URL, ModuleMetaData> mmds = HttpAuthenticationMechanismsTracker.getModuleMetaDataMapInternal();
        if (mmds != null && !mmds.isEmpty()) {
            for (Map.Entry<URL, ModuleMetaData> entry : mmds.entrySet()) {
                J2EEName j2eeName;
                ModuleMetaData mmd = entry.getValue();
                if (!(mmd instanceof WebModuleMetaData) || (j2eeName = mmd.getJ2EEName()) == null) continue;
                result = j2eeName.getApplication();
                break;
            }
        }
        return result;
    }

    private static Map<URL, ModuleMetaData> getModuleMetaDataMapInternal() {
        return ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().getModuleMetaDataMap();
    }

    protected Map<URL, ModuleMetaData> getModuleMetaDataMap() {
        return HttpAuthenticationMechanismsTracker.getModuleMetaDataMapInternal();
    }

    public Map<String, ModuleProperties> getModuleMap(String applicationName) {
        return this.moduleMapsPerApplication.get(applicationName);
    }

    public void addAuthMech(String applicationName, Class<?> annotatedClass, Class<?> implClass, Properties props) {
        Map<String, ModuleProperties> moduleMap = this.moduleMapsPerApplication.get(applicationName);
        String moduleName = this.getModuleFromClass(annotatedClass, moduleMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleName: " + moduleName), (Object[])new Object[0]);
        }
        if (moduleMap.containsKey(moduleName)) {
            moduleMap.get(moduleName).putToAuthMechMap(implClass, props);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Place the AuthMech to all modules since the module is not found  Module: " + moduleName), (Object[])new Object[0]);
            }
            for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
                entry.getValue().putToAuthMechMap(implClass, props);
            }
        }
    }

    public Properties removeAuthMech(String applicationName, Class<?> implClass) {
        return this.removeAuthMech(applicationName, implClass, implClass);
    }

    public Properties removeAuthMech(String applicationName, Class<?> annotatedClass, Class<?> implClass) {
        Map<String, ModuleProperties> moduleMap = this.moduleMapsPerApplication.get(applicationName);
        String moduleName = this.getModuleFromClass(annotatedClass, moduleMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleName: " + moduleName), (Object[])new Object[0]);
        }
        if (moduleMap.containsKey(moduleName)) {
            return moduleMap.get(moduleName).removeFromAuthMechMap(implClass);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Remove the AuthMech from all modules since the module is not found. Module: " + moduleName), (Object[])new Object[0]);
        }
        Properties props = null;
        for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
            props = entry.getValue().removeFromAuthMechMap(implClass);
        }
        return props;
    }

    private String getModuleFromClass(Class<?> annotatedClass, Map<String, ModuleProperties> moduleMap) {
        String file = this.getClassFileLocation(annotatedClass);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("File name : " + file), (Object[])new Object[0]);
        }
        String moduleName = null;
        for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
            URL location = entry.getValue().getLocation();
            String filePath = location.getFile();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("location : " + filePath), (Object[])new Object[0]);
            }
            if (!location.getProtocol().equals("file") || !file.startsWith(filePath)) continue;
            moduleName = entry.getKey();
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("module name from the list  : " + moduleName), (Object[])new Object[0]);
            break;
        }
        if (moduleName == null) {
            moduleName = file;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("no match. use filename as module name : " + moduleName), (Object[])new Object[0]);
            }
        }
        return moduleName;
    }

    protected String getClassFileLocation(Class<?> annotatedClass) {
        return annotatedClass.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    public boolean existAuthMech(String applicationName, Class<?> authMechToExist) {
        return null != this.getExistingAuthMechClass(applicationName, authMechToExist);
    }

    public Class<?> getExistingAuthMechClass(String applicationName) {
        return this.getExistingAuthMechClass(applicationName, null);
    }

    public Class<?> getExistingAuthMechClass(String applicationName, Class<?> authMechToExist) {
        Map authMechs = null;
        Map<String, ModuleProperties> moduleMap = this.moduleMapsPerApplication.get(applicationName);
        if (moduleMap != null) {
            for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
                authMechs = entry.getValue().getAuthMechMap();
                for (Class authMech : authMechs.keySet()) {
                    if (authMechToExist != null) {
                        if (!authMech.equals(authMechToExist)) continue;
                        return authMech;
                    }
                    return authMech;
                }
            }
        }
        return null;
    }

    public Map<Class<?>, Properties> getAuthMechs(String applicationName, String moduleName) {
        Map<String, ModuleProperties> moduleMap;
        Map authMechs = null;
        if (applicationName != null && !applicationName.isEmpty() && (moduleMap = this.moduleMapsPerApplication.get(applicationName)).containsKey(moduleName)) {
            authMechs = moduleMap.get(moduleName).getAuthMechMap();
        }
        return authMechs;
    }

    public boolean isEmptyModuleMap(String applicationName) {
        boolean result;
        if (applicationName == null || applicationName.isEmpty()) {
            return true;
        }
        Map<String, ModuleProperties> moduleMap = this.moduleMapsPerApplication.get(applicationName);
        boolean bl = result = moduleMap != null ? moduleMap.isEmpty() : true;
        if (!result) {
            for (Map.Entry<String, ModuleProperties> entry : moduleMap.entrySet()) {
                if (entry.getValue().getAuthMechMap().isEmpty()) {
                    result = true;
                    continue;
                }
                result = false;
                break;
            }
        }
        return result;
    }
}

