/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import com.ibm.ws.security.mp.jwt.MpConfigProxyService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.NoSuchElementException;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(property={"service.vendor=IBM"})
public class MpConfigUtil {
    private static TraceComponent tc = Tr.register(MpConfigUtil.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private static MpConfigProxyService mpConfigProxyService = null;
    static final long serialVersionUID = -5189356712873503113L;

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void setMpConfigProxyService(MpConfigProxyService proxyService) {
        if (mpConfigProxyService == null) {
            mpConfigProxyService = proxyService;
        } else if (proxyService != null && mpConfigProxyService.getVersion().compareTo(proxyService.getVersion()) < 0) {
            mpConfigProxyService = proxyService;
        }
    }

    protected void unsetMpConfigProxyService(MpConfigProxyService proxyService) {
        mpConfigProxyService = null;
    }

    public MpConfigProperties getMpConfig(HttpServletRequest req) {
        MpConfigProperties map = new MpConfigProperties();
        if (mpConfigProxyService != null) {
            return this.getMpConfigMap(mpConfigProxyService, this.getApplicationClassloader(req), map);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MP JWT feature is not enabled.", (Object[])new Object[0]);
        }
        return map;
    }

    protected ClassLoader getApplicationClassloader(HttpServletRequest req) {
        return req != null ? req.getServletContext().getClassLoader() : null;
    }

    protected MpConfigProperties getMpConfigMap(MpConfigProxyService service, ClassLoader cl, MpConfigProperties map) {
        Set<String> supportedMpConfigPropNames = service.getSupportedConfigPropertyNames();
        supportedMpConfigPropNames.forEach(s -> this.getMpConfig(service, cl, (String)s, map));
        return map;
    }

    @FFDCIgnore(value={NoSuchElementException.class})
    protected MpConfigProperties getMpConfig(MpConfigProxyService service, ClassLoader cl, String propertyName, MpConfigProperties map) {
        block6: {
            try {
                String value = service.getConfigValue(cl, propertyName, String.class);
                if (value != null) {
                    value = value.trim();
                }
                if (value != null && !value.isEmpty()) {
                    map.put((Object)propertyName, (Object)value);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(propertyName + " is empty or null. Ignore it."), (Object[])new Object[0]);
                }
            }
            catch (NoSuchElementException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)(propertyName + " is not in mpConfig."), (Object[])new Object[0]);
            }
        }
        return map;
    }
}

