/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.RemoteListCache;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class RemoteInstanceResult
implements Serializable {
    private static final long serialVersionUID = 2486399602489790552L;
    private final Date startTime;
    private final Properties header;
    private final HashSet<String> subProcs;
    private final ArrayList<RepositoryLogRecord> records = new ArrayList();
    private RemoteListCache cache = null;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public RemoteInstanceResult(Date startTime, Properties header, Set<String> subProcs) {
        this.startTime = startTime;
        this.header = header;
        this.subProcs = new HashSet<String>(subProcs);
    }

    public void addRecord(RepositoryLogRecord record) {
        this.records.add(record);
    }

    public ArrayList<RepositoryLogRecord> getLogList() {
        return this.records;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Properties getLogHeader() {
        return this.header;
    }

    public Set<String> getSubProcs() {
        return this.subProcs;
    }

    public RemoteListCache getCache() {
        return this.cache;
    }

    public void setCache(RemoteListCache cache) {
        this.cache = cache;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cache == null ? 0 : this.cache.hashCode());
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.records == null ? 0 : this.records.hashCode());
        result = 31 * result + (this.subProcs == null ? 0 : this.subProcs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteInstanceResult other = (RemoteInstanceResult)obj;
        if (this.cache == null ? other.cache != null : !this.cache.equals(other.cache)) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        if (this.records == null ? other.records != null : !this.records.equals(other.records)) {
            return false;
        }
        return !(this.subProcs == null ? other.subProcs != null : !this.subProcs.equals(other.subProcs));
    }
}

