/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.BaseDestination;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.internal.DestinationDefinitionImpl;
import com.ibm.ws.sib.admin.internal.JsAdminFactory;
import com.ibm.ws.sib.admin.internal.JsAdminFactoryImpl;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JsDestinationCache {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsDestinationCache";
    private static final TraceComponent tc = SibTr.register(JsDestinationCache.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private JsBusImpl _bus = null;
    private final HashMap tsAuditMap = null;
    private JsAdminFactory _jsaf = null;
    private final ArrayList<BaseDestination> _rawDestinations = new ArrayList();
    private final HashMap<String, HashMap<String, DestinationMapEntry>> _cacheByName = new HashMap();
    private final HashMap<String, HashMap<String, DestinationMapEntry>> _cacheByUuid = new HashMap();

    public JsDestinationCache(JsBusImpl bus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsDestinationCache", (Object)bus);
        }
        this._bus = bus;
        try {
            this._jsaf = JsAdminFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populateCache();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsDestinationCache", (Object)this);
        }
    }

    private void populateCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateCache", (Object)this);
        }
        try {
            HashMap destList = this._bus.getLWMMEConfig().getMessagingEngine().getDestinationList();
            Iterator entries = destList.entrySet().iterator();
            while (entries != null && entries.hasNext()) {
                DestinationDefinition dd;
                Map.Entry entry = entries.next();
                BaseDestination bd = (BaseDestination)entry.getValue();
                if (bd.isAlias()) {
                    AliasDestination alias = (AliasDestination)bd;
                    this._rawDestinations.add((BaseDestination)alias);
                    DestinationAliasDefinition dd2 = ((JsAdminFactoryImpl)this._jsaf).createDestinationAliasDefinition((LWMConfig)alias);
                    this.addEntry(this._bus.getName(), (BaseDestinationDefinition)dd2, (LWMConfig)alias);
                    continue;
                }
                SIBDestination oo = (SIBDestination)entry.getValue();
                this._rawDestinations.add((BaseDestination)oo);
                if (oo.getDestinationType() == DestinationType.QUEUE) {
                    SIBDestination queue = oo;
                    dd = ((JsAdminFactoryImpl)this._jsaf).createDestinationDefinition((LWMConfig)queue);
                    this.addEntry(this._bus.getName(), (BaseDestinationDefinition)dd, (LWMConfig)queue);
                    continue;
                }
                if (oo.getDestinationType() != DestinationType.TOPICSPACE) continue;
                SIBDestination topicspace = oo;
                dd = ((JsAdminFactoryImpl)this._jsaf).createDestinationDefinition((LWMConfig)topicspace);
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)dd, (LWMConfig)topicspace);
            }
        }
        catch (Exception e) {
            SibTr.error((TraceComponent)tc, (String)("POPULATE_DESTINATION_FAILED_SIAS0114" + e));
            e.printStackTrace();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateCache");
        }
    }

    private void addEntry(String busName, BaseDestinationDefinition dd, LWMConfig dest) {
        HashMap<String, DestinationMapEntry> destMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addEntry", (Object)new Object[]{busName, dd, dest});
        }
        if ((destMap = this._cacheByName.get(busName)) == null) {
            HashMap<String, DestinationMapEntry> newDestMap = new HashMap<String, DestinationMapEntry>();
            newDestMap.put(dd.getName(), new DestinationMapEntry(dd, dest));
            this._cacheByName.put(busName, newDestMap);
        } else {
            destMap.put(dd.getName(), new DestinationMapEntry(dd, dest));
            this._cacheByName.put(busName, destMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addEntry");
        }
    }

    private BaseDestinationDefinition getEntryByName(String busName, String name) {
        DestinationMapEntry entry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEntryByName", (Object)new Object[]{busName, name});
        }
        BaseDestinationDefinition returnEntry = null;
        HashMap<String, DestinationMapEntry> destMap = this._cacheByName.get(busName);
        if (destMap != null && (entry = destMap.get(name)) != null) {
            returnEntry = entry.getDestinationDefinition();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEntryByName", returnEntry);
        }
        return returnEntry;
    }

    private BaseDestinationDefinition getEntryByUuid(String busName, String uuid) {
        DestinationMapEntry entry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEntryByUuid", (Object)new Object[]{busName, uuid});
        }
        BaseDestinationDefinition returnEntry = null;
        HashMap<String, DestinationMapEntry> destMap = this._cacheByUuid.get(busName);
        if (destMap != null && (entry = destMap.get(uuid)) != null) {
            returnEntry = entry.getDestinationDefinition();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEntryByUuid", returnEntry);
        }
        return returnEntry;
    }

    private void illegalArguments(String s) throws SIBExceptionBase {
        throw new SIBExceptionBase("Illegal argument value(s) specified; " + s);
    }

    public BaseDestinationDefinition getSIBDestination(String busName, String name) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        BaseDestinationDefinition dd;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestination", (Object)new Object[]{busName, name});
        }
        String bus = null;
        if (name == null) {
            this.illegalArguments("name is mandatory");
        }
        if ((dd = this.getEntryByName(bus = busName == null || busName.equals("") ? this._bus.getName() : busName, name)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSIBDestination", (Object)"SIBExceptionDestinationNotFound");
            }
            throw new SIBExceptionDestinationNotFound(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestination", (Object)dd);
        }
        return dd;
    }

    public BaseDestinationDefinition getSIBDestinationByUuid(String busName, String uuid) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        BaseDestinationDefinition dd;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestinationByUuid", (Object)new Object[]{busName, uuid});
        }
        String bus = null;
        if (uuid == null) {
            this.illegalArguments("uuid is mandatory");
        }
        if ((dd = this.getEntryByUuid(bus = busName == null || busName.equals("") ? this._bus.getName() : busName, uuid)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationByUuid", (Object)"SIBExceptionDestinationNotFound");
            }
            throw new SIBExceptionDestinationNotFound(uuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationByUuid", (Object)dd);
        }
        return dd;
    }

    public void getSIBDestination(String busName, String name, DestinationDefinition dd) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        LWMConfig sibdd;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestination", (Object)new Object[]{busName, name, dd});
        }
        String bus = null;
        if (name == null || dd == null) {
            this.illegalArguments("name or dd are mandatory");
        }
        if ((sibdd = this._getSIBDestination(bus = busName == null || busName.equals("") ? this._bus.getName() : busName, name)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSIBDestination", (Object)"SIBExceptionDestinationNotFound");
            }
            throw new SIBExceptionDestinationNotFound(name);
        }
        ((DestinationDefinitionImpl)dd).reset(sibdd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestination");
        }
    }

    public Set getSIBDestinationLocalitySet(String busName, String uuid) throws SIBExceptionBase {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)new Object[]{busName, uuid});
        }
        if (uuid == null) {
            this.illegalArguments("name is mandatory");
        }
        if (busName != null && !busName.equals(this._bus.getName())) {
            this.illegalArguments("will only currently support single bus");
        }
        Set set = this._getSIBDestinationLocalitySet(busName, uuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)set);
        }
        return set;
    }

    private LWMConfig _getSIBDestination(String busName, String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBDestination", (Object)new Object[]{busName, name});
        }
        HashMap destList = null;
        String bus = null;
        Object destBus = null;
        bus = busName == null || busName.equals("") ? this._bus.getName() : busName;
        destList = this._bus.getLWMMEConfig().getMessagingEngine().getDestinationList();
        BaseDestination dest = null;
        Iterator entries = destList.entrySet().iterator();
        while (entries.hasNext() && dest == null) {
            Map.Entry entry = entries.next();
            BaseDestination d = (BaseDestination)entry.getValue();
            if (!d.getName().equalsIgnoreCase(name)) continue;
            dest = d;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBDestination", dest);
        }
        return dest;
    }

    private Set _getSIBDestinationLocalitySet(String busName, String uuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getSIBDestinationLocalitySet", (Object)new Object[]{busName, uuid});
        }
        HashSet set = new HashSet();
        Iterator<BaseDestination> _i = this._rawDestinations.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getSIBDestinationLocalitySet", set);
        }
        return set;
    }

    private void populateAuditMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateAuditMap", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateAuditMap");
        }
    }

    public void populateUuidCache(ArrayList list) throws Exception {
        String busName = this._bus.getName();
        Iterator iter = list.iterator();
        HashMap<String, DestinationMapEntry> storedUUIDMap = this._cacheByUuid.get(busName);
        if (storedUUIDMap == null) {
            storedUUIDMap = new HashMap();
        }
        HashMap<String, DestinationMapEntry> storedNameMap = this._cacheByName.get(busName);
        while (iter.hasNext()) {
            BaseDestinationDefinition bdef = (BaseDestinationDefinition)iter.next();
            Object destDef = bdef.isAlias() ? (DestinationAliasDefinition)bdef : (DestinationDefinition)bdef;
            DestinationMapEntry destMapEntry = this.setLocalizedDestinationInUUIDCache((BaseDestinationDefinition)destDef);
            String dname = destDef.getName();
            if (storedUUIDMap.containsKey(dname)) {
                storedUUIDMap.remove(dname);
            }
            storedUUIDMap.put(destDef.getUUID().toString(), destMapEntry);
            if (storedNameMap.containsKey(dname)) {
                storedNameMap.remove(dname);
            }
            storedNameMap.put(dname, destMapEntry);
        }
        this._cacheByName.put(busName, storedNameMap);
        this._cacheByUuid.put(busName, storedUUIDMap);
    }

    private DestinationMapEntry setLocalizedDestinationInUUIDCache(BaseDestinationDefinition destDef) {
        SibTr.entry((TraceComponent)tc, (String)("setLocalizedDestinationInUUIDCache" + destDef));
        BaseDestination destConfig = this.getDestinationConfigByName(destDef);
        SibTr.exit((TraceComponent)tc, (String)"setLocalizedDestinationInUUIDCache");
        return new DestinationMapEntry(destDef, (LWMConfig)destConfig);
    }

    private BaseDestination getDestinationConfigByName(BaseDestinationDefinition destDef) {
        HashMap destMap = this._bus.getLWMMEConfig().getMessagingEngine().getDestinationList();
        BaseDestination dConfig = (BaseDestination)destMap.get(destDef.getName());
        return dConfig;
    }

    public BaseDestinationDefinition addNewDestinationToCache(BaseDestination config) {
        DestinationAliasDefinition dd = null;
        if (!config.isAlias()) {
            SIBDestination dest = (SIBDestination)config;
            this._rawDestinations.add((BaseDestination)dest);
            if (dest.getDestinationType() == DestinationType.QUEUE) {
                BaseDestination queue = config;
                dd = ((JsAdminFactoryImpl)this._jsaf).createDestinationDefinition((LWMConfig)queue);
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)dd, (LWMConfig)queue);
            } else if (dest.getDestinationType() == DestinationType.TOPICSPACE) {
                BaseDestination topicspace = config;
                dd = ((JsAdminFactoryImpl)this._jsaf).createDestinationDefinition((LWMConfig)topicspace);
                this.addEntry(this._bus.getName(), (BaseDestinationDefinition)dd, (LWMConfig)topicspace);
            }
        } else {
            AliasDestination d = (AliasDestination)config;
            this._rawDestinations.add((BaseDestination)d);
            dd = ((JsAdminFactoryImpl)this._jsaf).createDestinationAliasDefinition((LWMConfig)config);
            this.addEntry(this._bus.getName(), (BaseDestinationDefinition)dd, (LWMConfig)d);
        }
        return dd;
    }

    public void deleteDestination(String busName, String destName) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"deleteDestination");
        Iterator<BaseDestination> iter = this._rawDestinations.iterator();
        while (iter.hasNext()) {
            BaseDestination dest = iter.next();
            if (!dest.getName().equals(destName)) continue;
            iter.remove();
        }
        HashMap<String, DestinationMapEntry> mp = this._cacheByName.get(busName);
        mp.remove(destName);
        SibTr.exit((TraceComponent)tc, (String)("deleteDestination" + destName));
    }

    private class DestinationMapEntry {
        private BaseDestinationDefinition _dd = null;
        private final Set _set = new HashSet();

        private DestinationMapEntry(BaseDestinationDefinition dd, LWMConfig dest) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"DestinationMapEntry", (Object)new Object[]{dd, dest});
            }
            this._dd = dd;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"DestinationMapEntry", (Object)this);
            }
        }

        private BaseDestinationDefinition getDestinationDefinition() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getDestinationDefinition", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getDestinationDefinition", (Object)this._dd);
            }
            return this._dd;
        }
    }
}

