/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.SIBLocalizationPoint;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LocalizationDefinitionImpl
implements LocalizationDefinition {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl";
    private static final TraceComponent tc = SibTr.register(LocalizationDefinitionImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private final String _configId;
    private long _destinationHighMsgs = Long.MAX_VALUE;
    private long _destinationLowMsgs = Long.MAX_VALUE;
    private String _identifier = null;
    private boolean _sendAllowed = true;
    private SIBUuid12 _targetUuid = null;
    private SIBUuid12 _uuid = null;
    private long _alterationTime;

    LocalizationDefinitionImpl(String name) {
        this._configId = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.<init>", (Object)name);
        }
        this._identifier = name;
        this._uuid = new SIBUuid12();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.<init>");
        }
    }

    LocalizationDefinitionImpl(SIBUuid12 targetUuid) {
        this._configId = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.<init>", (Object)targetUuid);
        }
        this._identifier = targetUuid.toString();
        this._targetUuid = targetUuid;
        this._uuid = new SIBUuid12();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.<init>");
        }
    }

    LocalizationDefinitionImpl(LWMConfig lp) {
        this._configId = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.<init>", (Object)lp);
        }
        SIBLocalizationPoint lpConfig = (SIBLocalizationPoint)lp;
        this._identifier = lpConfig.getIdentifier();
        this._destinationHighMsgs = lpConfig.getHighMsgThreshold();
        this._destinationLowMsgs = this._destinationHighMsgs * 8L / 10L;
        this._sendAllowed = lpConfig.isSendAllowed();
        this._uuid = new SIBUuid12();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.<init>");
        }
    }

    public String getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._uuid);
        }
        return this._uuid.toString();
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName", (Object)this._identifier);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._identifier);
        }
        return this._identifier;
    }

    public long getAlterationTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAlterationTime", (Object)this._alterationTime);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(this._alterationTime);
            SibTr.exit((TraceComponent)tc, (String)"getAlterationTime", (Object)l.toString());
        }
        return this._alterationTime;
    }

    public void setAlterationTime(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(value);
            SibTr.entry((TraceComponent)tc, (String)"setAlterationTime", (Object)l);
        }
        this._alterationTime = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAlterationTime");
        }
    }

    public long getDestinationHighMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)this._destinationHighMsgs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(this._destinationHighMsgs);
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)l.toString());
        }
        return this._destinationHighMsgs;
    }

    public void setDestinationHighMsgs(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(value);
            SibTr.entry((TraceComponent)tc, (String)"setDestinationHighMsgs", (Object)l);
        }
        this._destinationHighMsgs = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationHighMsgs");
        }
    }

    public long getDestinationLowMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLowMsgs", (Object)this._destinationLowMsgs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(this._destinationLowMsgs);
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLowMsgs", (Object)l.toString());
        }
        return this._destinationLowMsgs;
    }

    public void setDestinationLowMsgs(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(value);
            SibTr.entry((TraceComponent)tc, (String)"setDestinationLowMsgs", (Object)l);
        }
        this._destinationLowMsgs = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationLowMsgs");
        }
    }

    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed", (Object)this._sendAllowed);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = new Boolean(this._sendAllowed);
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)b);
        }
        return this._sendAllowed;
    }

    public void setSendAllowed(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = new Boolean(value);
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)b.toString());
        }
        this._sendAllowed = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSendAllowed");
        }
    }

    public Object clone() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.LocalizationDefinitionImpl.clone", (Object)this);
        }
        LocalizationDefinitionImpl obj = null;
        try {
            obj = (LocalizationDefinitionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)"PROBE_ID_10", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"clone", (Object)e);
            }
            InternalError ie = new InternalError(e.toString());
            throw ie;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clone");
        }
        return obj;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        result.append("uuid=");
        result.append(this._uuid);
        result.append(":targetUuid=");
        result.append(this._targetUuid);
        result.append(":configId=");
        result.append(this._configId);
        result.append(":sendAllowed=");
        result.append(this._sendAllowed);
        result.append(":identifier=");
        result.append(this._identifier);
        result.append(":destinationHighMsgs=");
        result.append(this._destinationHighMsgs);
        result.append(":destinationLowMsgs=");
        result.append(this._destinationLowMsgs);
        return result.toString();
    }

    public void setUUID(SIBUuid8 uuid) {
    }
}

