/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.gd.RangeList;
import com.ibm.ws.sib.processor.gd.RangeObject;
import com.ibm.ws.sib.processor.utils.BlockVector;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ARangeList
implements RangeList {
    private static TraceComponent tc = SibTr.register(ARangeList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private BlockVector blockVector;
    private int cursor;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public void init(RangeObject ro) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"init", (Object)ro);
        }
        this.blockVector = new BlockVector();
        ro.startstamp = 0L;
        ro.endstamp = Long.MAX_VALUE;
        this.blockVector.add(ro);
        this.cursor = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    @Override
    public void setCursor(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCursor", (Object)stamp);
        }
        this.cursor = stamp == 0L ? 0 : this.getIndex(stamp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCursor", (Object)new Object[]{this.cursor, this.blockVector.size()});
        }
    }

    @Override
    public Object getMark(Object mark) {
        Marker mmark;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMark", (Object)mark);
        }
        if ((mmark = (Marker)mark) == null) {
            mmark = new Marker(this.cursor);
        } else {
            mmark.position = this.cursor;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMark", (Object)mmark);
        }
        return mmark;
    }

    @Override
    public void setCursor(Object mark) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCursor", (Object)mark);
        }
        this.cursor = ((Marker)mark).position;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCursor", (Object)new Object[]{this.cursor, this.blockVector.size()});
        }
    }

    @Override
    public RangeObject getNext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNext", (Object)this.cursor);
        }
        int curr = this.cursor;
        int n = this.cursor = this.cursor < this.blockVector.size() - 1 ? this.cursor + 1 : this.cursor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNext", (Object)new Object[]{this.blockVector.get(curr), this.cursor});
        }
        return (RangeObject)this.blockVector.get(curr);
    }

    @Override
    public RangeObject getPrev() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPrev", (Object)this.cursor);
        }
        int curr = this.cursor;
        int n = this.cursor = this.cursor > 0 ? this.cursor - 1 : this.cursor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPrev", (Object)new Object[]{this.blockVector.get(curr), this.cursor});
        }
        return (RangeObject)this.blockVector.get(curr);
    }

    @Override
    public RangeObject getCurr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCurr", (Object)this.cursor);
            SibTr.exit((TraceComponent)tc, (String)"getCurr", this.blockVector.get(this.cursor));
        }
        return (RangeObject)this.blockVector.get(this.cursor);
    }

    @Override
    public void get(RangeObject r, BlockVector readList) {
        this.get(r.startstamp, r.endstamp, readList);
    }

    @Override
    public void get(long startstamp, long endstamp, BlockVector readList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)new Object[]{startstamp, endstamp, readList});
        }
        int findex = this.getIndex(startstamp);
        int length = this.blockVector.size();
        for (int i = findex; i < length; ++i) {
            RangeObject ro = (RangeObject)this.blockVector.get(i);
            if (ro.startstamp > endstamp) break;
            readList.add(ro);
        }
        this.cursor = findex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)this.cursor);
        }
    }

    @Override
    public void replace(BlockVector writeList) {
        int count;
        int index;
        RangeObject lastro;
        int findex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"replace", (Object)writeList);
        }
        boolean pushed = false;
        int wlength = writeList.size();
        long fstamp = ((RangeObject)writeList.get((int)0)).startstamp;
        long lstamp = ((RangeObject)writeList.get((int)(wlength - 1))).endstamp;
        int lindex = findex = this.linearSearch(fstamp, 0, this.blockVector.size() - 1);
        while (true) {
            lastro = (RangeObject)this.blockVector.get(lindex);
            if (lstamp <= lastro.endstamp && lstamp >= lastro.startstamp) break;
            ++lindex;
        }
        if (findex == lindex) {
            if (fstamp > lastro.startstamp && lstamp < lastro.endstamp) {
                RangeObject ro2 = (RangeObject)lastro.clone();
                ro2.startstamp = lstamp + 1L;
                writeList.add(ro2);
                pushed = true;
                lastro.endstamp = fstamp - 1L;
                index = findex + 1;
                count = ++wlength;
            } else if (fstamp > lastro.startstamp) {
                lastro.endstamp = fstamp - 1L;
                index = findex + 1;
                count = wlength;
            } else if (lstamp < lastro.endstamp) {
                lastro.startstamp = lstamp + 1L;
                index = findex;
                count = wlength;
            } else {
                index = findex;
                count = wlength - 1;
            }
        } else {
            count = wlength - (lindex - findex + 1);
            index = findex;
            RangeObject firstro = (RangeObject)this.blockVector.get(findex);
            if (fstamp > firstro.startstamp) {
                firstro.endstamp = fstamp - 1L;
                ++index;
                ++count;
            }
            if (lstamp < lastro.endstamp) {
                lastro.startstamp = lstamp + 1L;
                ++count;
            }
        }
        if (count > 0) {
            this.blockVector.insertNullElementsAt(index, count);
        } else if (count < 0) {
            count = -count;
            this.blockVector.removeElementsAt(index, count);
        }
        for (int i = 0; i < writeList.size(); ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Setting " + writeList.get(i) + " at index " + (i + index)));
            }
            this.blockVector.set(i + index, writeList.get(i));
            if (this.blockVector.get(i + index) != null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"replace", (Object)("SIErrorException: null range at index " + (i + index)));
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ARangeList", "1:347:1.25", "Null range at index " + (i + index)}, null));
        }
        if (pushed) {
            writeList.remove(writeList.size() - 1);
        }
        this.cursor = index;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replace", (Object)this.cursor);
        }
    }

    @Override
    public void replacePrefix(RangeObject w) {
        RangeObject lastro;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"replacePrefix", (Object)w);
        }
        long lstamp = w.endstamp;
        int lindex = 0;
        while (true) {
            lastro = (RangeObject)this.blockVector.get(lindex);
            if (lstamp <= lastro.endstamp && lstamp >= lastro.startstamp) break;
            ++lindex;
        }
        if (lstamp < lastro.endstamp) {
            lastro.startstamp = lstamp + 1L;
            if (lindex == 0) {
                this.blockVector.insertNullElementsAt(0, 1);
            } else if (lindex - 1 > 0) {
                this.blockVector.removeElementsAt(0, lindex - 1);
            }
        } else if (lindex > 0) {
            this.blockVector.removeElementsAt(0, lindex);
        }
        this.blockVector.set(0, w);
        this.cursor = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replacePrefix");
        }
    }

    @Override
    public void splitStart(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"splitStart", (Object)new Object[]{stamp, this.cursor});
        }
        RangeObject ro = (RangeObject)this.blockVector.get(this.cursor);
        if (ro.startstamp == stamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitStart");
            }
            return;
        }
        if (stamp > ro.endstamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitStart", (Object)new Object[]{"A", stamp, ro.endstamp});
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:445:1.25"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:454:1.25"});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitStart", (String)"1:460:1.25", (Object)this);
            throw e;
        }
        if (stamp < ro.startstamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitStart", (Object)new Object[]{"B", stamp, ro.startstamp});
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:479:1.25"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:487:1.25"});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitStart", (String)"1:493:1.25", (Object)this);
            throw e;
        }
        RangeObject ro2 = (RangeObject)ro.clone();
        ro2.endstamp = stamp - 1L;
        ro.startstamp = stamp;
        this.blockVector.insertNullElementsAt(this.cursor, 1);
        this.blockVector.set(this.cursor, ro2);
        ++this.cursor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"splitStart", (Object)this.cursor);
        }
    }

    @Override
    public void splitEnd(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"splitEnd", (Object)new Object[]{stamp, this.cursor});
        }
        RangeObject ro = (RangeObject)this.blockVector.get(this.cursor);
        if (stamp == ro.endstamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitEnd");
            }
            return;
        }
        if (stamp > ro.endstamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitEnd", (Object)new Object[]{"A", stamp, ro.endstamp});
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:544:1.25"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:552:1.25"});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitEnd", (String)"1:558:1.25", (Object)this);
            throw e;
        }
        if (stamp < ro.startstamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitEnd", (Object)new Object[]{"B", stamp, ro.startstamp});
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:577:1.25"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:586:1.25"});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitEnd", (String)"1:592:1.25", (Object)this);
            throw e;
        }
        RangeObject ro2 = (RangeObject)ro.clone();
        ro2.endstamp = stamp;
        ro.startstamp = stamp + 1L;
        this.blockVector.insertNullElementsAt(this.cursor, 1);
        this.blockVector.set(this.cursor, ro2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"splitEnd");
        }
    }

    protected final int getIndex(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getIndex", (Object)stamp);
        }
        int first = 0;
        int last = this.blockVector.size();
        int index = this.linearSearch(stamp, first, last - 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getIndex", (Object)index);
        }
        return index;
    }

    protected final int linearSearch(long stamp, int first, int last) {
        int i;
        RangeObject ro;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"linearSearch", (Object)new Object[]{stamp, first, last, this.cursor});
        }
        if ((ro = (RangeObject)this.blockVector.get(i = this.cursor)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"linearSearch", (Object)("SIErrorException: Null range under cursor at index " + i));
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ARangeList", "1:650:1.25", "Null range at index " + i}, null));
        }
        if (stamp >= ro.startstamp && stamp <= ro.endstamp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"linearSearch - index matched", (Object)i);
            }
            return i;
        }
        if (stamp > ro.endstamp) {
            first = i + 1;
        } else if (stamp < ro.startstamp) {
            last = i - 1;
        }
        for (i = last; i >= first; --i) {
            ro = (RangeObject)this.blockVector.get(i);
            if (ro == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"linearSearch", (Object)("SIErrorException: Null range at index " + i));
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ARangeList", "1:683:1.25", "Null range at index " + i}, null));
            }
            if (stamp >= ro.startstamp && stamp <= ro.endstamp) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"linearSearch", (Object)i);
        }
        return i;
    }

    class Marker {
        int position;

        public Marker(int pos) {
            this.position = pos;
        }

        public String toString() {
            return super.toString() + "(" + this.position + ")";
        }
    }
}

