/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd.statestream;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.processor.gd.statestream.TickData;
import com.ibm.ws.sib.processor.gd.statestream.TickRangeType;
import com.ibm.ws.sib.processor.utils.linkedlist2.Entry;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class TickRange
extends Entry
implements Cloneable {
    private static TraceComponent tc = SibTr.register(TickRange.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = 0L;
    protected TickRangeType type;
    protected long start;
    protected long end;
    protected TickData data;

    public TickRange() {
    }

    public TickRange(TickRangeType type, long start, long end) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TickRange", (Object)new Object[]{type, new Long(start), new Long(end)});
        }
        if (start > end) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0008", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.TickRange", "1:92:1.2", new Long(start), new Long(end)}, null));
        }
        this.reset(type, start, end);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TickRange", (Object)this);
        }
    }

    public TickRange(TickRangeType type, long start, long end, TickData data) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TickRange", (Object)new Object[]{type, new Long(start), new Long(end), data});
        }
        if (start > end) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0008", new Object[]{"com.ibm.ws.sib.processor.gd.statestream.TickRange", "1:131:1.2", new Long(start), new Long(end)}, null));
        }
        this.reset(type, start, end, data);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TickRange", (Object)this);
        }
    }

    public void reset(TickRangeType type, long start, long end) {
        this.reset(type, start, end, null);
    }

    public void reset(TickRangeType type, long start, long end, TickData data) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset", (Object)new Object[]{type, new Long(start), new Long(end), data});
        }
        this.type = type;
        this.start = start;
        this.end = end;
        this.data = data;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public boolean contains(long tick) {
        return this.start <= tick && this.end >= tick;
    }

    public boolean isInUse() {
        return this.parentList != null;
    }

    public long diff(long tick) {
        long diff = tick - this.start;
        if (this.contains(tick)) {
            diff = 0L;
        } else if (diff > 0L) {
            diff = tick - this.end;
        }
        return diff;
    }

    @Override
    public String toString(String indent) {
        String ret = indent + "[" + this.type + " Start:" + TickRange.tickToString(this.start) + ", End:" + (this.end == Long.MAX_VALUE ? "      LAST" : TickRange.tickToString(this.end)) + ", Data:" + (this.data == null ? "null     " : "@" + Integer.toString(this.data.hashCode(), 16)) + "]";
        return ret;
    }

    protected static String tickToString(long tick) {
        String blanks = "          ";
        String highBits = Long.toString(tick >>> 32);
        highBits = blanks.substring(0, blanks.length() - highBits.length()) + highBits;
        String lowBits = Long.toString(tick & 0xFFFFFFFFL);
        lowBits = blanks.substring(0, blanks.length() - lowBits.length()) + lowBits;
        return lowBits;
    }

    public TickData getData() {
        return this.data;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public TickRangeType getType() {
        return this.type;
    }
}

