/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem;
import com.ibm.ws.sib.utils.ras.SibTr;

public class AIStreamKey {
    private static final TraceComponent tc = SibTr.register(AIStreamKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final long tick;
    private RemoteDispatchableKey ck;
    private final long originalTimeout;
    private final long issueTime;
    private AIProtocolItem acceptedItem;

    public AIStreamKey(long timestamp, RemoteDispatchableKey ck, long originalTimeout, long issueTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIStreamKey", (Object)new Object[]{timestamp, ck, originalTimeout, issueTime});
        }
        this.tick = timestamp;
        this.ck = ck;
        this.originalTimeout = originalTimeout;
        this.issueTime = issueTime;
        this.acceptedItem = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIStreamKey", (Object)this);
        }
    }

    public AIStreamKey(long timestamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIStreamKey", (Object)timestamp);
        }
        this.tick = timestamp;
        this.ck = null;
        this.originalTimeout = 0L;
        this.issueTime = 0L;
        this.acceptedItem = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIStreamKey", (Object)this);
        }
    }

    public RemoteDispatchableKey getRemoteDispatchableKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteDispatchableKey");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteDispatchableKey", (Object)this.ck);
        }
        return this.ck;
    }

    public void clearRemoteDispatchableKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearRemoteDispatchableKey");
            SibTr.exit((TraceComponent)tc, (String)"clearRemoteDispatchableKey");
        }
        this.ck = null;
    }

    public long getTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)this.tick);
        }
        return this.tick;
    }

    public long getOriginalTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOriginalTimeout");
            SibTr.exit((TraceComponent)tc, (String)"getOriginalTimeout", (Object)this.originalTimeout);
        }
        return this.originalTimeout;
    }

    public long getIssueTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIssueTime");
            SibTr.exit((TraceComponent)tc, (String)"getIssueTime", (Object)this.issueTime);
        }
        return this.issueTime;
    }

    public AIProtocolItem getAcceptedItem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAcceptedItem");
            SibTr.exit((TraceComponent)tc, (String)"getAcceptedItem", (Object)this.acceptedItem);
        }
        return this.acceptedItem;
    }

    public void setAcceptedItem(AIProtocolItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAcceptedItem", (Object)item);
            SibTr.exit((TraceComponent)tc, (String)"setAcceptedItem");
        }
        this.acceptedItem = item;
    }
}

