/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GatheringBrowseCursor
implements BrowseCursor {
    private static final TraceComponent tc = SibTr.register(GatheringBrowseCursor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    List<BrowseCursor> cursors;

    public GatheringBrowseCursor(SelectionCriteria selectionCriteria, JSConsumerManager localCD, Map<SIBUuid8, JSConsumerManager> remoteCDs) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"GatheringBrowseCursor", (Object)new Object[]{selectionCriteria, localCD, remoteCDs});
        }
        this.cursors = new LinkedList<BrowseCursor>();
        this.cursors.add(localCD.getBrowseCursor(selectionCriteria));
        for (JSConsumerManager remoteCD : remoteCDs.values()) {
            this.cursors.add(remoteCD.getBrowseCursor(selectionCriteria));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"GatheringBrowseCursor", (Object)this);
        }
    }

    @Override
    public void finished() throws SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        Iterator<BrowseCursor> it = this.cursors.iterator();
        while (it.hasNext()) {
            it.next().finished();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    @Override
    public JsMessage next() throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        JsMessage msg = null;
        Iterator<BrowseCursor> it = this.cursors.iterator();
        while (it.hasNext() && msg == null) {
            msg = it.next().next();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next");
        }
        return msg;
    }
}

