/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LocalQPConsumerKeyFilter
implements Filter {
    private static final TraceComponent tc = SibTr.register(LocalQPConsumerKeyFilter.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final Filter parentFilter;
    private int classIndex = 0;
    private String classificationName = null;
    private LockingCursor getCursor;

    public LocalQPConsumerKeyFilter(Filter parentFilter, int classIndex, String classificationName) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalQPConsumerKeyFilter", (Object)new Object[]{parentFilter, classIndex, classificationName});
        }
        this.parentFilter = parentFilter;
        this.classIndex = classIndex;
        this.classificationName = classificationName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKeyFilter", (Object)this);
        }
    }

    public boolean filterMatches(AbstractItem item) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)item);
        }
        boolean result = true;
        if (this.classIndex > 0) {
            result = false;
            boolean throwExceptionIfMessageNotAvailable = false;
            String keyClassification = ((SIMPMessage)item).getMessageControlClassification(throwExceptionIfMessageNotAvailable);
            if (keyClassification != null && keyClassification.equalsIgnoreCase(this.classificationName)) {
                result = true;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("filter class: " + this.classificationName + ", message class: " + keyClassification));
            }
        }
        if (result) {
            result = this.parentFilter.filterMatches(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)result);
        }
        return result;
    }

    public void setLockingCursor(LockingCursor cursor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLockingCursor", (Object)cursor);
        }
        this.getCursor = cursor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLockingCursor");
        }
    }

    protected LockingCursor getGetCursor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursor");
        }
        LockingCursor cursor = this.getCursor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursor", (Object)cursor);
        }
        return cursor;
    }

    protected void detach() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detach");
        }
        this.getCursor.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detach");
        }
    }

    protected void discard() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discard");
        }
        if (this.getCursor != null) {
            this.getCursor.finished();
            this.getCursor = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discard");
        }
    }
}

