/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.BaseLocalizationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MQLinkDefinition;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.comms.mq.MQLinkObject;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MQLinkLocalization;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkPubSubBridgeItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPMQLinkQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MQLinkControl;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.mql.MQLinkManager;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class MQLinkHandler
extends LinkHandler
implements MQLinkLocalization {
    private static final TraceComponent tc = SibTr.register(MQLinkHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SIBUuid8 _mqLinkUuid;
    private String _mqLinkName;
    private MQLinkObject _mqLinkObject;
    private ItemStream _mqLinkStateItemStream;
    private long _mqLinkStateItemStreamId;
    private MQLinkPubSubBridgeItemStream _mqLinkPubSubBridgeItemStream;
    private MQLinkManager _mqLinkManager;
    private boolean _registeredInWLM = false;
    private LinkManager _linkManager;
    private boolean _psbMBeanRegistered = false;

    public MQLinkHandler() {
    }

    public MQLinkHandler(MQLinkDefinition mqld, VirtualLinkDefinition virtualLinkDefinition, MessageProcessor messageProcessor, SIMPItemStream parentItemStream, TransactionCommon transaction, HashMap durableSubscriptionsTable) throws SIResourceException, MessageStoreException {
        super(virtualLinkDefinition, messageProcessor, parentItemStream, transaction, durableSubscriptionsTable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MQLinkHandler", (Object)new Object[]{mqld, virtualLinkDefinition, messageProcessor, parentItemStream, transaction, durableSubscriptionsTable});
        }
        this._mqLinkUuid = mqld.getUuid();
        this._mqLinkName = mqld.getName();
        DestinationDefinition mqLinkDestDefinition = messageProcessor.createDestinationDefinition(DestinationType.QUEUE, virtualLinkDefinition.getName());
        mqLinkDestDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        mqLinkDestDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        this.updateDefinition((BaseDestinationDefinition)mqLinkDestDefinition);
        this._mqLinkStateItemStream = null;
        Transaction msTran = messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
        this._mqLinkPubSubBridgeItemStream = new MQLinkPubSubBridgeItemStream(this, msTran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQLinkHandler", (Object)this);
        }
    }

    @Override
    public void reconstitute(MessageProcessor processor, HashMap durableSubscriptionsTable, int startMode) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Object[]{processor, durableSubscriptionsTable, startMode});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reconstituting MQLink " + this.getName()));
        }
        try {
            super.reconstitute(processor, durableSubscriptionsTable, startMode);
            if (this._mqLinkStateItemStreamId != 0L) {
                this._mqLinkStateItemStream = (ItemStream)this.findById(this._mqLinkStateItemStreamId);
                if (this._mqLinkStateItemStream == null && !this.isToBeDeleted()) {
                    SIResourceException e = new SIResourceException(nls.getFormattedMessage("LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", new Object[]{this.getName()}, null));
                    SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", (Object)new Object[]{this.getName()});
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.reconstitute", (String)"1:270:1.71", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)e));
                    }
                    throw e;
                }
            }
            NonLockingCursor cursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(MQLinkPubSubBridgeItemStream.class));
            this._mqLinkPubSubBridgeItemStream = (MQLinkPubSubBridgeItemStream)cursor.next();
            if (this._mqLinkPubSubBridgeItemStream == null && !this.isToBeDeleted()) {
                SIResourceException e = new SIResourceException(nls.getFormattedMessage("LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", new Object[]{this.getName()}, null));
                SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", (Object)new Object[]{this.getName()});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.reconstitute", (String)"1:303:1.71", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)e));
                }
                throw e;
            }
            cursor.finished();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.reconstitute", (String)"1:325:1.71", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            this._isCorruptOrIndoubt = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public MQLinkPubSubBridgeItemStream getMqLinkPubSubBridgeItemStream() {
        return this._mqLinkPubSubBridgeItemStream;
    }

    public ItemStream getMQLinkStateItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkStateItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkStateItemStream", (Object)this._mqLinkStateItemStream);
        }
        return this._mqLinkStateItemStream;
    }

    public void setMQLinkStateItemStream(ItemStream mqLinkStateItemStream) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)new Object[]{mqLinkStateItemStream});
        }
        if (this._mqLinkStateItemStream != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("MQLINK_STATE_ITEMSTREAM_ALREADY_EXISTS", null, null));
        }
        this._mqLinkStateItemStream = mqLinkStateItemStream;
        ExternalAutoCommitTransaction transaction = this.messageProcessor.getTXManager().createAutoCommitTransaction();
        try {
            this.addItemStream(mqLinkStateItemStream, (Transaction)transaction);
            this._mqLinkStateItemStreamId = mqLinkStateItemStream.getID();
            this.requestUpdate((Transaction)transaction);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.setMQLinkStateItemStream", (String)"1:5452:1.341", (Object)this);
            SIResourceException eCore = new SIResourceException(nls.getFormattedMessage("MQLINK_STATE_ITEMSTREAM_MESSAGE_STORE_ERROR", null, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)((Object)eCore));
            }
            throw eCore;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream");
        }
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            this.addPersistentDestinationData(hm);
            this.addPersistentLinkData(hm);
            hm.put("mqlinkuuid", this._mqLinkUuid.toByteArray());
            hm.put("mqlinkname", this._mqLinkName);
            hm.put("mqlinkstateid", this._mqLinkStateItemStreamId);
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.getPersistentData", (String)"1:477:1.71", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler.getPersistentData", "1:484:1.71", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler.getPersistentData", "1:494:1.71", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, dataVersion});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this.restorePersistentDestinationData(hm);
            this.restorePersistentLinkData(hm);
            this._mqLinkUuid = new SIBUuid8((byte[])hm.get("mqlinkuuid"));
            this._mqLinkName = (String)hm.get("mqlinkname");
            this._mqLinkStateItemStreamId = (Long)hm.get("mqlinkstateid");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.restore", (String)"1:536:1.71", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler", "1:543:1.71", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler", "1:553:1.71", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanupDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination");
        }
        boolean cleanedUp = false;
        MQLinkHandler mQLinkHandler = this;
        synchronized (mQLinkHandler) {
            if (this.isToBeDeleted()) {
                LocalTransaction siTran = this.txManager.createLocalTransaction(true);
                this.removeStateItemStreams((Transaction)siTran);
                siTran.commit();
            }
        }
        cleanedUp = this.cleanupBaseDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination", (Object)cleanedUp);
        }
        return cleanedUp;
    }

    @Override
    void initializeNonPersistent(MessageProcessor messageProcessor, HashMap durableSubscriptionsTable, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)new Object[]{messageProcessor, durableSubscriptionsTable, transaction});
        }
        this._mqLinkManager = messageProcessor.getMQLinkManager();
        this._linkManager = messageProcessor.getLinkManager();
        super.initializeNonPersistent(messageProcessor, durableSubscriptionsTable, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public SIBUuid8 getMqLinkUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMqLinkUuid");
            SibTr.exit((TraceComponent)tc, (String)"getMqLinkUuid", (Object)this._mqLinkUuid);
        }
        return this._mqLinkUuid;
    }

    public MQLinkObject getMQLinkObject() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkObject");
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkObject", (Object)this._mqLinkObject);
        }
        return this._mqLinkObject;
    }

    public void setMQLinkObject(MQLinkObject mqLinkObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMQLinkObject", (Object)mqLinkObject);
        }
        this._mqLinkObject = mqLinkObject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMQLinkObject");
        }
    }

    @Override
    public boolean isMQLink() {
        return true;
    }

    @Override
    void registerDestination() {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"registerDestination");
            }
            if (this._mqLinkManager.isDefined(this.getUuid()) && this.hasLocal() && !this._registeredInWLM) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Register MQLink: " + this.getUuid() + ", with linkManager"));
                    }
                    this._linkManager.register(this.getUuid());
                    this._registeredInWLM = true;
                }
                catch (LinkException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.registerDestination", (String)"1:724:1.71", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block6;
                    SibTr.exit((TraceComponent)tc, (String)"registerDestination", (Object)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    @Override
    void deregisterDestination() {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
            }
            try {
                if (this._registeredInWLM) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Deregister MQLink: " + this.getUuid() + ", from LinkManager"));
                    }
                    this._linkManager.deregister(this.getUuid());
                }
                this._registeredInWLM = false;
            }
            catch (LinkException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.deregisterDestination", (String)"1:769:1.71", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block6;
                SibTr.exit((TraceComponent)tc, (String)"deregisterDestination", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    public void registerLink() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerLink");
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Register MQLink: " + this.getUuid() + ", with mqLinkManager"));
            }
            this._mqLinkManager.define(this.getUuid());
        }
        catch (LinkException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.registerLink", (String)"1:804:1.71", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerLink", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        this.registerDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerLink");
        }
    }

    public void deregisterLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterLink");
        }
        this.deregisterDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Deregister MQLink: " + this.getUuid() + ", with mqLinkManager"));
        }
        this._mqLinkManager.undefine(this.getUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterLink");
        }
    }

    @Override
    public void updatePostRegistration(boolean advertise) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updatePostRegistration", (Object)advertise);
        }
        if (advertise) {
            this.registerDestination();
        } else {
            this.deregisterDestination();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updatePostRegistration");
        }
    }

    private void removeStateItemStreams(Transaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeStateItemStreams", (Object)transaction);
        }
        try {
            if (this._mqLinkStateItemStream != null && this._mqLinkStateItemStream.isInStore()) {
                Item item = null;
                while (null != (item = this._mqLinkStateItemStream.findFirstMatchingItem(null))) {
                    item.remove(transaction, -2L);
                }
                this._mqLinkStateItemStream.remove(transaction, -2L);
            }
            if (this._mqLinkPubSubBridgeItemStream != null && this._mqLinkPubSubBridgeItemStream.isInStore()) {
                this._mqLinkPubSubBridgeItemStream.removeAll(transaction);
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.removeStateItemStreams", (String)"1:910:1.71", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeStateItemStreams", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeStateItemStreams");
        }
    }

    protected MQLinkMessageItemStream addNewMQLinkLocalisation(TransactionCommon transaction, SIBUuid8 messagingEngineUuid, LocalizationDefinition destinationLocalizationDefinition) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)new Object[]{transaction, destinationLocalizationDefinition});
        }
        MQLinkMessageItemStream mqlinkItemStream = null;
        try {
            mqlinkItemStream = new MQLinkMessageItemStream(this, messagingEngineUuid);
            this._localisationManager.addNewLocalPtoPLocalisation(transaction, mqlinkItemStream);
            Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction(transaction);
            this.addItemStream(mqlinkItemStream, msTran);
            mqlinkItemStream.setDefaultDestLimits();
            mqlinkItemStream.setDestMsgInterval();
            mqlinkItemStream.updateLocalizationDefinition(destinationLocalizationDefinition);
            this.attachPtoPLocalisation(mqlinkItemStream, false);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.addNewMQLinkLocalisation", (String)"1:998:1.71", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)mqlinkItemStream);
        }
        return mqlinkItemStream;
    }

    @Override
    public void stop(int mode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        super.stop(mode);
        try {
            if (this._mqLinkObject != null) {
                this._mqLinkObject.stop();
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        this._mqLinkManager.undefine(this.getUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void delete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete");
        }
        try {
            LocalTransaction siTran = this.txManager.createLocalTransaction(true);
            this.setToBeDeleted(true);
            this.destinationManager.getLinkIndex().delete(this);
            this.requestUpdate((Transaction)siTran);
            siTran.commit();
            String name = this._mqLinkName;
            if (name == null) {
                name = this.getName();
            }
            SibTr.info((TraceComponent)tc, (String)"MQLINK_DEST_DELETE_INFO_CWSIP0064", (Object)new Object[]{name, this._mqLinkUuid});
        }
        catch (MessageStoreException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        this.destinationManager.startAsynchDeletion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    public void announceMPStarted(int startMode, JsMessagingEngine me) throws SIResourceException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStarted", (Object)new Object[]{startMode, me});
        }
        if (this._mqLinkObject != null) {
            this._mqLinkObject.mpStarted(startMode, me);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStarted");
        }
    }

    public void destroy() throws SIResourceException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (this._mqLinkObject != null) {
            this._mqLinkObject.destroy();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new MQLinkControl(this.messageProcessor, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public SIMPMQLinkQueuePointControllable getSIMPMQLinkQueuePointControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIMPMQLinkQueuePointControllable");
        }
        ControlAdapter ca = null;
        SIMPMQLinkQueuePointControllable mqlinkca = null;
        LocalizationPoint stream = this.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
        if (stream instanceof MQLinkMessageItemStream && (ca = stream.getControlAdapter()) instanceof SIMPMQLinkQueuePointControllable) {
            mqlinkca = (SIMPMQLinkQueuePointControllable)ca;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIMPMQLinkQueuePointControllable");
        }
        return mqlinkca;
    }

    @Override
    protected void updateLocalizationDefinition(BaseLocalizationDefinition destinationLocalizationDefinition, TransactionCommon transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalizationDefinition", (Object)new Object[]{destinationLocalizationDefinition, transaction});
        }
        this._ptoPRealization.updateLocalisationDefinition(destinationLocalizationDefinition, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalizationDefinition");
        }
    }
}

