/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalXAResource;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.transactions.TransactionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIXAResource;

public final class SIMPTransactionManager {
    private MessageStore msgStore;
    private static TraceComponent tc = SibTr.register(SIMPTransactionManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private TransactionFactory transactionFactory;
    private MessageProcessor messageProcessor;
    private String localRMName;

    public SIMPTransactionManager(MessageProcessor messageProcessor, MessageStore msgStore) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SIMPTransactionManager", (Object)new Object[]{messageProcessor, msgStore});
        }
        this.messageProcessor = messageProcessor;
        this.msgStore = msgStore;
        this.transactionFactory = msgStore.getTransactionFactory();
        this.localRMName = "WebSphere PM Resource Manager " + messageProcessor.getMessagingEngineName() + "-" + messageProcessor.getMessagingEngineBus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SIMPTransactionManager", (Object)this);
        }
    }

    public String getLocalRMName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalRMName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalRMName", (Object)this.localRMName);
        }
        return this.localRMName;
    }

    public LocalTransaction createLocalTransaction(boolean useSingleResourceOnly) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLocalTransaction");
        }
        ExternalLocalTransaction tran = null;
        tran = this.transactionFactory.createLocalTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLocalTransaction", (Object)tran);
        }
        return tran;
    }

    public ExternalAutoCommitTransaction createAutoCommitTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAutoCommitTransaction");
        }
        ExternalAutoCommitTransaction transaction = this.transactionFactory.createAutoCommitTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAutoCommitTransaction", (Object)transaction);
        }
        return transaction;
    }

    public SIXAResource createXAResource(boolean useSingleResource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createXAResource", (Object)new Boolean(useSingleResource));
        }
        ExternalXAResource resource = null;
        resource = this.transactionFactory.createXAResource();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createXAResource", (Object)resource);
        }
        return resource;
    }

    public MessageStore getMessageStore() {
        return this.msgStore;
    }

    public Transaction resolveAndEnlistMsgStoreTransaction(TransactionCommon transactionCommon) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolveAndEnlistMsgStoreTransaction", (Object)transactionCommon);
        }
        Transaction msgStoreTran = null;
        if (transactionCommon != null) {
            msgStoreTran = (Transaction)transactionCommon;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolveAndEnlistMsgStoreTransaction", (Object)msgStoreTran);
        }
        return msgStoreTran;
    }
}

