/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class MPIOMsgDebug {
    public static final String toString(ControlMessage controlMsg, int priority) {
        return MPIOMsgDebug.debug(null, controlMsg, priority);
    }

    public static final String debug(TraceComponent tc, ControlMessage controlMsg, int priority) {
        long endTick;
        long startTick;
        ProtocolType protocolType = controlMsg.getGuaranteedProtocolType();
        ControlMessageType controlType = controlMsg.getControlMessageType();
        int hashCode = controlMsg.hashCode();
        int msgPriority = controlMsg.getPriority() == null ? 0 : controlMsg.getPriority();
        int sendPriority = priority;
        SIBUuid12 streamId = controlMsg.getGuaranteedStreamUUID();
        if (controlType == ControlMessageType.ACK) {
            startTick = ((ControlAck)controlMsg).getAckPrefix();
            endTick = -1L;
        } else if (controlType == ControlMessageType.ACKEXPECTED) {
            startTick = ((ControlAckExpected)controlMsg).getTick();
            endTick = -1L;
        } else if (controlType == ControlMessageType.NACK) {
            startTick = ((ControlNack)controlMsg).getStartTick();
            endTick = ((ControlNack)controlMsg).getEndTick();
        } else if (controlType == ControlMessageType.SILENCE) {
            startTick = ((ControlSilence)controlMsg).getStartTick();
            endTick = ((ControlSilence)controlMsg).getEndTick();
        } else {
            startTick = -1L;
            endTick = -1L;
        }
        SIBUuid8 targetMessaginEngineUUID = controlMsg.getGuaranteedTargetMessagingEngineUUID();
        SIBUuid8 sourceMessaginEngineUUID = controlMsg.getGuaranteedSourceMessagingEngineUUID();
        SIBUuid12 targetDestDefUUID = controlMsg.getGuaranteedTargetDestinationDefinitionUUID();
        SIBUuid8 sourceBusUUID = controlMsg.getGuaranteedCrossBusSourceBusUUID();
        String linkName = controlMsg.getGuaranteedCrossBusLinkName();
        JsDestinationAddress routingDestination = controlMsg.getRoutingDestination();
        if (tc != null) {
            MPIOMsgDebug.debug(tc, protocolType, controlType, hashCode, msgPriority, sendPriority, startTick, endTick, streamId, targetMessaginEngineUUID, sourceMessaginEngineUUID, targetDestDefUUID, sourceBusUUID, linkName, routingDestination);
            return null;
        }
        return MPIOMsgDebug.toString(protocolType, controlType, hashCode, msgPriority, sendPriority, startTick, endTick, streamId, targetMessaginEngineUUID, sourceMessaginEngineUUID, targetDestDefUUID, sourceBusUUID, linkName, routingDestination);
    }

    public static final String toString(JsMessage jsMsg, int priority) {
        return MPIOMsgDebug.debug(null, jsMsg, priority);
    }

    public static final String debug(TraceComponent tc, JsMessage jsMsg, int priority) {
        ProtocolType protocolType = jsMsg.getGuaranteedProtocolType();
        ControlMessageType controlType = null;
        int hashCode = jsMsg.hashCode();
        int msgPriority = jsMsg.getPriority() == null ? 0 : jsMsg.getPriority();
        int sendPriority = priority;
        long startTick = jsMsg.getGuaranteedValueValueTick();
        long endTick = -1L;
        SIBUuid12 streamId = jsMsg.getGuaranteedStreamUUID();
        SIBUuid8 targetMessaginEngineUUID = jsMsg.getGuaranteedTargetMessagingEngineUUID();
        SIBUuid8 sourceMessaginEngineUUID = jsMsg.getGuaranteedSourceMessagingEngineUUID();
        SIBUuid12 targetDestDefUUID = jsMsg.getGuaranteedTargetDestinationDefinitionUUID();
        SIBUuid8 sourceBusUUID = jsMsg.getGuaranteedCrossBusSourceBusUUID();
        String linkName = jsMsg.getGuaranteedCrossBusLinkName();
        JsDestinationAddress routingDestination = jsMsg.getRoutingDestination();
        if (tc != null) {
            MPIOMsgDebug.debug(tc, protocolType, controlType, hashCode, msgPriority, sendPriority, startTick, -1L, streamId, targetMessaginEngineUUID, sourceMessaginEngineUUID, targetDestDefUUID, sourceBusUUID, linkName, routingDestination);
            return null;
        }
        return MPIOMsgDebug.toString(protocolType, controlType, hashCode, msgPriority, sendPriority, startTick, -1L, streamId, targetMessaginEngineUUID, sourceMessaginEngineUUID, targetDestDefUUID, sourceBusUUID, linkName, routingDestination);
    }

    private static final String toString(ProtocolType protocolType, ControlMessageType controlType, int hashCode, int msgPriority, int sendPriority, long startTick, long endTick, SIBUuid12 streamId, SIBUuid8 targetMessaginEngineUUID, SIBUuid8 sourceMessaginEngineUUID, SIBUuid12 targetDestDefUUID, SIBUuid8 sourceBusUUID, String linkName, JsDestinationAddress routingDestination) {
        StringBuffer buffer = new StringBuffer(protocolType.toString());
        if (controlType == null) {
            buffer.append(" data message");
        } else {
            buffer.append(" ");
            buffer.append(controlType);
            buffer.append(" message\n");
        }
        buffer.append("HashCode           : ");
        buffer.append(Integer.toHexString(hashCode));
        buffer.append("\n");
        if (sendPriority != -1) {
            buffer.append("Send Priority      : ");
            buffer.append(sendPriority);
            buffer.append("(msg)\n");
        }
        buffer.append("Msg Priority       : ");
        buffer.append(msgPriority);
        buffer.append("(msg)\n");
        buffer.append("Tick               : ");
        buffer.append(startTick);
        if (endTick != -1L) {
            buffer.append("/");
            buffer.append(endTick);
        }
        buffer.append("\n");
        buffer.append("StreamId           : ");
        buffer.append(streamId);
        buffer.append("\n");
        buffer.append("Source ME          : ");
        buffer.append(sourceMessaginEngineUUID);
        buffer.append("\n");
        buffer.append("Target ME          : ");
        buffer.append(targetMessaginEngineUUID);
        buffer.append("\n");
        buffer.append("Target Dest        : ");
        buffer.append(targetDestDefUUID);
        buffer.append("\n");
        buffer.append("Source Bus         : ");
        buffer.append(sourceBusUUID);
        buffer.append("\n");
        buffer.append("Link Name          : ");
        buffer.append(linkName);
        buffer.append("\n");
        if (routingDestination != null) {
            buffer.append("Routing Dest Name: ");
            buffer.append(routingDestination.getDestinationName());
            buffer.append("\n");
            buffer.append("Routing Dest Bus : ");
            buffer.append(routingDestination.getBusName());
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private static final void debug(TraceComponent tc, ProtocolType protocolType, ControlMessageType controlType, int hashCode, int msgPriority, int sendPriority, long startTick, long endTick, SIBUuid12 streamId, SIBUuid8 targetMessaginEngineUUID, SIBUuid8 sourceMessaginEngineUUID, SIBUuid12 targetDestDefUUID, SIBUuid8 sourceBusUUID, String linkName, JsDestinationAddress routingDestination) {
        if (controlType == null) {
            SibTr.debug((TraceComponent)tc, (String)(protocolType + " data message"));
        } else {
            SibTr.debug((TraceComponent)tc, (String)(protocolType + " " + controlType + " message"));
        }
        SibTr.debug((TraceComponent)tc, (String)("HashCode           : " + Integer.toHexString(hashCode)));
        if (sendPriority != -1) {
            SibTr.debug((TraceComponent)tc, (String)("Send Priority      : " + sendPriority));
        }
        SibTr.debug((TraceComponent)tc, (String)("Msg Priority       : " + msgPriority));
        SibTr.debug((TraceComponent)tc, (String)("Tick               : " + startTick));
        if (endTick != -1L) {
            SibTr.debug((TraceComponent)tc, (String)("Tick               : " + startTick + "/" + endTick));
        } else {
            SibTr.debug((TraceComponent)tc, (String)("Tick               : " + startTick));
        }
        SibTr.debug((TraceComponent)tc, (String)("StreamId           : " + streamId));
        SibTr.debug((TraceComponent)tc, (String)("Source ME          : " + sourceMessaginEngineUUID));
        SibTr.debug((TraceComponent)tc, (String)("Target ME          : " + targetMessaginEngineUUID));
        SibTr.debug((TraceComponent)tc, (String)("Target Dest        : " + targetDestDefUUID));
        SibTr.debug((TraceComponent)tc, (String)("Source Bus         : " + sourceBusUUID));
        SibTr.debug((TraceComponent)tc, (String)("Link Name          : " + linkName));
        if (routingDestination != null) {
            SibTr.debug((TraceComponent)tc, (String)("Routing Dest Name: " + routingDestination.getDestinationName()));
            SibTr.debug((TraceComponent)tc, (String)("Routing Dest Bus : " + routingDestination.getBusName()));
        }
    }

    public static void debug(TraceComponent tc, AbstractMessage aMessage, int priority) {
        if (aMessage.isControlMessage()) {
            MPIOMsgDebug.debug(tc, (ControlMessage)aMessage, priority);
        } else {
            MPIOMsgDebug.debug(tc, (JsMessage)aMessage, priority);
        }
    }
}

