/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLinkTransmitterControllable;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamControl;
import com.ibm.ws.sib.processor.runtime.impl.InternalOutputStreamSetControl;
import com.ibm.ws.sib.processor.runtime.impl.LinkRemoteTopicSpaceControl;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkPublicationPointControl
extends InternalOutputStreamSetControl
implements SIMPLinkTransmitterControllable {
    private static TraceComponent tc = SibTr.register(LinkPublicationPointControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DestinationHandler _topicspace = null;
    LinkRemoteTopicSpaceControl control = null;

    public LinkPublicationPointControl(StreamSet streamSet) {
        super(streamSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkPublicationPointControl", (Object)streamSet);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkPublicationPointControl", (Object)this);
        }
    }

    @Override
    public void setParentControlAdapter(ControlAdapter parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setParentControlAdapter", (Object)parent);
        }
        super.setParentControlAdapter(parent);
        this.control = (LinkRemoteTopicSpaceControl)parent;
        this._topicspace = this.control.getOutputHandler().getDestinationHandler();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setParentControlAdapter");
        }
    }

    public long getTimeSinceLastMessageSent() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTimeSinceLastMessageSent");
        }
        long maxTime = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            InternalOutputStreamControl streamControl = (InternalOutputStreamControl)iterator.next();
            long streamTime = streamControl.getLastMsgSentTime();
            if (streamTime <= maxTime) continue;
            maxTime = streamTime;
        }
        maxTime = maxTime == 0L ? -1L : System.currentTimeMillis() - maxTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTimeSinceLastMessageSent", (Object)maxTime);
        }
        return maxTime;
    }

    public boolean isPutInhibited() {
        boolean isPI;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPutInhibited");
        }
        boolean bl = isPI = !this._topicspace.isSendAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isPutInhibited", (Object)isPI);
        }
        return isPI;
    }

    public String getLinkType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkType");
        }
        String type = this.control.getLinkControl().getType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkType", (Object)type);
        }
        return type;
    }

    public String getLinkUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkUuid");
        }
        String uuid = this.control.getLinkControl().getId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkUuid", (Object)uuid);
        }
        return uuid;
    }

    public String getLinkName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkName");
        }
        String name = this.control.getLinkControl().getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkName", (Object)name);
        }
        return name;
    }

    public String getTargetBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBusName");
        }
        String name = this.control.getLinkControl().getTargetBus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetBusName", (Object)name);
        }
        return name;
    }

    public String getTargetEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTargetEngineUuid", (Object)super.getRemoteEngineUuid());
        }
        return super.getRemoteEngineUuid();
    }

    public void reallocateAllTransmitMessages() throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateAllTransmitMessages");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateAllTransmitMessages");
        }
    }

    public String getTargetDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetDestination");
        }
        String target = ((LinkRemoteTopicSpaceControl)this.parent).getTargetDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetDestination", (Object)target);
        }
        return target;
    }

    public boolean isPublicationTransmitter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPublicationTransmitter");
            SibTr.exit((TraceComponent)tc, (String)"isPublicationTransmitter", (Object)true);
        }
        return true;
    }
}

