/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLinkReceiverControllable;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamControl;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamSetControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkReceiverControl
extends TargetStreamSetControl
implements SIMPLinkReceiverControllable {
    private static TraceComponent tc = SibTr.register(LinkReceiverControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String linkTarget;

    public LinkReceiverControl(StreamSet streamSet, String linkTarget) {
        super(streamSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkReceiverControl", (Object)new Object[]{streamSet, linkTarget});
        }
        this.linkTarget = linkTarget;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkReceiverControl", (Object)this);
        }
    }

    public long getTimeSinceLastMessageReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTimeSinceLastMessageReceived");
        }
        long maxTime = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            TargetStreamControl targetStreamControl = (TargetStreamControl)iterator.next();
            long streamTime = targetStreamControl.getLastMsgReceivedTime();
            if (streamTime <= maxTime) continue;
            maxTime = streamTime;
        }
        maxTime = maxTime == 0L ? -1L : System.currentTimeMillis() - maxTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTimeSinceLastMessageReceived", (Object)maxTime);
        }
        return maxTime;
    }

    public String getLinkUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkUuid");
        }
        SIBUuid12 uuid = this.tsm.getDestinationHandler().getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkUuid", (Object)uuid);
        }
        return uuid.toString();
    }

    public String getLinkName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkName");
        }
        String name = this.tsm.getDestinationHandler().getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkName", (Object)name);
        }
        return name;
    }

    public String getSourceBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceBusName");
        }
        String name = null;
        DestinationHandler dh = this.tsm.getDestinationHandler();
        if (dh.isLink()) {
            name = ((LinkHandler)dh).getBusName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSourceBusName", (Object)name);
        }
        return name;
    }

    public String getSourceEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceEngineUuid");
        }
        String uuid = this.getRemoteEngineUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSourceEngineUuid", (Object)uuid);
        }
        return uuid;
    }

    public String getTargetDestinationName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetDestinationName");
        }
        String target = this.linkTarget;
        if (!this.isPublicationReceiver()) {
            target = "UNKNOWN";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetDestinationName", (Object)target);
        }
        return target;
    }

    public boolean isPublicationReceiver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPublicationReceiver");
        }
        boolean isPubSub = true;
        if (this.linkTarget != null && this.linkTarget.equals("_PTOP_TARGET_STREAM")) {
            isPubSub = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isPublicationReceiver", (Object)isPubSub);
        }
        return isPubSub;
    }
}

