/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionIndex;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPVirtualLinkControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AttachedRemoteSubscriberIterator;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.ControllableIterator;
import com.ibm.ws.sib.processor.runtime.impl.KnownDurableSubscription;
import com.ibm.ws.sib.processor.runtime.impl.LocalQueuePointIterator;
import com.ibm.ws.sib.processor.runtime.impl.LocalSubscriptionControl;
import com.ibm.ws.sib.processor.runtime.impl.Queue;
import com.ibm.ws.sib.processor.runtime.impl.RemoteQueuePointIterator;
import com.ibm.ws.sib.processor.runtime.impl.Topicspace;
import com.ibm.ws.sib.processor.runtime.impl.VirtualLinkControl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class MessageProcessorControl
extends AbstractControlAdapter
implements SIMPMessageProcessorControllable {
    private static final TraceComponent tc = SibTr.register(MessageProcessorControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private DestinationIndex destinationIndex;
    private MessageProcessor messageProcessor;
    private DestinationManager destinationManager;
    private Index links;

    public MessageProcessorControl(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorControl", (Object)new Object[]{messageProcessor});
        }
        this.messageProcessor = messageProcessor;
        this.destinationManager = messageProcessor.getDestinationManager();
        this.destinationIndex = this.destinationManager.getDestinationIndex();
        this.links = new Index();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorControl");
        }
    }

    public SIMPIterator getForeignBusIterator() {
        ForeignBusTypeFilter filter = new ForeignBusTypeFilter();
        SIMPIterator foreignBusItr = this.destinationManager.getForeignBusIndex().iterator(filter);
        return new ControllableIterator((Iterator)foreignBusItr);
    }

    public SIMPIterator getVirtualLinkIterator() {
        LinkTypeFilter filter = new LinkTypeFilter();
        ControllableIterator linkItr = new ControllableIterator((Iterator)this.destinationManager.getLinkIndex().iterator(filter));
        if (!this.links.isEmpty()) {
            while (linkItr.hasNext()) {
                VirtualLinkControl linkControl = (VirtualLinkControl)linkItr.next();
                if (this.links.get(linkControl.getName()) == null) continue;
                linkControl.merge((VirtualLinkControl)this.links.remove(linkControl.getName()));
            }
            linkItr.finished();
            linkItr = new ControllableIterator((Iterator)this.destinationManager.getLinkIndex().iterator(filter));
        }
        return linkItr;
    }

    public SIMPIterator getQueueIterator() {
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.TRUE;
        SIMPIterator queuesItr = this.destinationIndex.iterator(filter);
        return new ControllableIterator((Iterator)queuesItr);
    }

    public SIMPIterator getLocalQueueIterator() {
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.TRUE;
        filter.LOCAL = Boolean.TRUE;
        SIMPIterator queuesItr = this.destinationIndex.iterator(filter);
        return new ControllableIterator((Iterator)queuesItr);
    }

    public SIMPIterator getRemoteQueueIterator() {
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.TRUE;
        filter.REMOTE = Boolean.TRUE;
        SIMPIterator queuesItr = this.destinationIndex.iterator(filter);
        return new ControllableIterator((Iterator)queuesItr);
    }

    public SIMPIterator getTopicSpaceIterator() {
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.FALSE;
        SIMPIterator topicspacesItr = this.destinationIndex.iterator(filter);
        return new ControllableIterator((Iterator)topicspacesItr);
    }

    public SIMPIterator getLocalQueuePointIterator() {
        return new LocalQueuePointIterator(this.getLocalQueueIterator());
    }

    public SIMPIterator getRemoteQueuePointIterator() {
        return new RemoteQueuePointIterator(this.getRemoteQueueIterator());
    }

    public SIMPIterator getKnownDurableSubscriptionsIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getKnownDurableSubscriptionsIterator");
        }
        SIMPIterator topicSpaces = this.getTopicSpaceIterator();
        LinkedList<KnownDurableSubscription> subs = new LinkedList<KnownDurableSubscription>();
        while (topicSpaces.hasNext()) {
            try {
                Topicspace ts = (Topicspace)topicSpaces.next();
                SIMPIterator sub = ts.getDurableSubscriptionIterator();
                while (sub.hasNext()) {
                    subs.add(new KnownDurableSubscription((LocalSubscriptionControl)sub.next()));
                }
            }
            catch (SIMPException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessorControl.getKnownDurableSubscriptionsIterator", (String)"1:265:1.52", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessorControl.getKnownDurableSubscriptionsIterator", "1:270:1.52", SIMPUtils.getStackTrace(exception)});
            }
        }
        BasicSIMPIterator itr = new BasicSIMPIterator(subs.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getKnownDurableSubscriptionsIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPIterator getConnectionsIterator() {
        return null;
    }

    public SIMPQueueControllable getQueueControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueueControlByID", (Object)new Object[]{id});
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.TRUE;
        SIMPQueueControllable control = (SIMPQueueControllable)this.getMessageHandlerControlByID(id, filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueueControlByID", (Object)control);
        }
        return control;
    }

    private SIMPMessageHandlerControllable getMessageHandlerControlByID(String id, DestinationTypeFilter filter) throws SIMPInvalidRuntimeIDException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)new Object[]{id});
        }
        SIBUuid12 uuid = null;
        try {
            uuid = new SIBUuid12(id);
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessorControl.getMessageHandlerControlByID", (String)"1:331:1.52", (Object)this);
            SIMPInvalidRuntimeIDException finalE = new SIMPInvalidRuntimeIDException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"MessageProcessorControl.getMessageHandlerControlByID", "1:339:1.52", e, id}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"MessageProcessorControl.getMessageHandlerControlByID", "1:347:1.52", e, id});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)((Object)finalE));
            }
            throw finalE;
        }
        DestinationHandler dest = this.destinationIndex.findByUuid(uuid, filter);
        SIMPMessageHandlerControllable control = null;
        if (dest == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DESTINATION_NOT_FOUND_ERROR_CWSIP0341", new Object[]{id, this.messageProcessor.getMessagingEngineName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)((Object)finalE));
            }
            throw finalE;
        }
        control = (SIMPMessageHandlerControllable)dest.getControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandlerControlByID", (Object)control);
        }
        return control;
    }

    public SIMPQueueControllable getQueueControlByName(String name, String bus) throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueueControlByName", (Object)new Object[]{name, bus});
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.VISIBLE = Boolean.TRUE;
        DestinationHandler dest = this.destinationIndex.findByName(name, bus, filter);
        if (dest == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DESTINATION_NOT_FOUND_ERROR_CWSIP0341", new Object[]{name, this.messageProcessor.getMessagingEngineName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueueControlByName", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueueControlByName");
        }
        return (SIMPQueueControllable)dest.getControlAdapter();
    }

    public SIMPTopicSpaceControllable getTopicSpaceControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceControlByID", (Object)new Object[]{id});
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.FALSE;
        SIMPTopicSpaceControllable control = (SIMPTopicSpaceControllable)this.getMessageHandlerControlByID(id, filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceControlByID", (Object)control);
        }
        return control;
    }

    private SIMPControllable findControllableFromItemStream(SIMPItemStream is, String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)new Object[]{id});
        }
        ControllableResource resource = null;
        ControlAdapter control = null;
        try {
            resource = (ControllableResource)is.findById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.MessageProcessorControl.findControllableFromMsgStore", (String)"1:457:1.52", (Object)this);
            SIMPInvalidRuntimeIDException finalE = new SIMPInvalidRuntimeIDException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"MessageProcessorControl.findControllableFromMsgStore", "1:465:1.52", e, id}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"MessageProcessorControl.findControllableFromMsgStore", "1:473:1.52", e, id});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)((Object)finalE));
            }
            throw finalE;
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.MessageProcessorControl.findControllableFromMsgStore", (String)"1:484:1.52", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (resource == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"MessageProcessorControl.findControllableFromMsgStore", "1:499:1.52", id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)((Object)finalE));
            }
            throw finalE;
        }
        control = resource.getControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findControllableFromMsgStore", (Object)control);
        }
        return control;
    }

    public SIMPLocalQueuePointControllable getLocalQueuePointControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        DestinationHandler dest;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalQueuePointControlByID", (Object)new Object[]{id});
        }
        SIMPLocalQueuePointControllable control = null;
        String[] tokens = id.split("_QUEUE_");
        if (tokens.length > 0 && (dest = this.destinationManager.getDestinationInternal(new SIBUuid12(tokens[0]), false)) != null) {
            try {
                control = (SIMPLocalQueuePointControllable)this.findControllableFromItemStream((SIMPItemStream)((Object)dest), tokens[1]);
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.MessageProcessorControl.getLocalQueuePointControlByID", (String)"1:550:1.52", (Object)this);
                SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"MessageProcessorControl.getLocalQueuePointControlByID", "1:558:1.52", id}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getLocalQueuePointControlByID", (Object)((Object)finalE));
                }
                throw finalE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalQueuePointControlByID");
        }
        return control;
    }

    public SIMPRemoteQueuePointControllable getRemoteQueuePointControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        ControlAdapter control;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQueuePointControlByID", (Object)new Object[]{id});
        }
        SIMPRemoteQueuePointControllable rqp = null;
        String[] tokens = id.split("_REMOTE_QUEUE_");
        DestinationHandler dest = null;
        if (tokens.length > 0 && (dest = this.destinationManager.getDestinationInternal(new SIBUuid12(tokens[0]), true)) != null && (control = dest.getControlAdapter()) instanceof Queue) {
            rqp = ((Queue)control).getRemoteQueuePointControlByMEUuid(tokens[1]);
        }
        if (dest == null || rqp == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls_cwsik.getFormattedMessage("DESTINATION_NOT_FOUND_ERROR_CWSIP0341", new Object[]{id, this.messageProcessor.getMessagingEngineName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByID", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQueuePointControlByID");
        }
        return rqp;
    }

    public SIMPIterator getAliasIterator() {
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.ALIAS = Boolean.TRUE;
        SIMPIterator aliasItr = this.destinationIndex.iterator(filter);
        return new ControllableIterator((Iterator)aliasItr);
    }

    public SIMPIterator getForeignDestinationIterator() {
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.FOREIGN_DESTINATION = Boolean.TRUE;
        SIMPIterator destItr = this.destinationIndex.iterator(filter);
        return new ControllableIterator((Iterator)destItr);
    }

    public String getId() {
        return "" + this.messageProcessor.getID();
    }

    public String getName() {
        return this.messageProcessor.getMessagingEngineName();
    }

    public SIMPIterator getLocalSubscriptionIterator() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionIterator");
        }
        SIMPIterator topicSpaces = this.getTopicSpaceIterator();
        SubscriptionIndex subs = new SubscriptionIndex();
        while (topicSpaces.hasNext()) {
            Topicspace ts = (Topicspace)topicSpaces.next();
            SIMPIterator sub = ts.getInternalLocalSubscriptionIterator();
            while (sub.hasNext()) {
                subs.put((ControllableSubscription)sub.next());
            }
        }
        ControllableIterator itr = new ControllableIterator((Iterator)subs.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPLocalSubscriptionControllable getLocalSubscriptionControlByID(String id) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionControlByID");
        }
        SIMPIterator topicSpaces = this.getTopicSpaceIterator();
        SIMPLocalSubscriptionControllable localSub = null;
        while (topicSpaces.hasNext()) {
            Topicspace ts = (Topicspace)topicSpaces.next();
            SIMPIterator subs = ts.getLocalSubscriptionIterator();
            while (subs.hasNext()) {
                SIMPLocalSubscriptionControllable sub = (SIMPLocalSubscriptionControllable)subs.next();
                if (!sub.getId().equals(id)) continue;
                localSub = sub;
                break;
            }
            if (localSub == null) continue;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", localSub);
        }
        return localSub;
    }

    public SIMPIterator getRemoteSubscriptionIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSubscriptionIterator");
        }
        DestinationTypeFilter filter = new DestinationTypeFilter();
        filter.QUEUE = Boolean.FALSE;
        LinkedList mpAIHCollection = new LinkedList();
        SIMPIterator iter = this.destinationIndex.iterator(filter);
        while (iter.hasNext()) {
            BaseDestinationHandler destination = (BaseDestinationHandler)iter.next();
            Map destAIHMap = destination.getPseudoDurableAIHMap();
            mpAIHCollection.add(destAIHMap.values());
        }
        AttachedRemoteSubscriberIterator remoteSubscriptionItr = new AttachedRemoteSubscriberIterator(mpAIHCollection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSubscriptionIterator", (Object)remoteSubscriptionItr);
        }
        return remoteSubscriptionItr;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.messageProcessor == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"MessageProcessorControl.assertValidControllable", "1:888:1.52", null}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.messageProcessor = null;
        this.destinationIndex = null;
        this.destinationManager = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public void resetDestination(String destName) throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetMessageHandler", (Object)destName);
        }
        try {
            this.destinationManager.resetDestination(destName);
        }
        catch (Exception e) {
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetMessageHandler");
        }
    }

    public void resetLink(String linkName) throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetLink", (Object)linkName);
        }
        try {
            this.destinationManager.resetLink(linkName);
        }
        catch (Exception e) {
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetLink");
        }
    }

    public SIMPIterator getLocalTopicSpaceControllables() {
        LinkedList<SIMPLocalTopicSpaceControllable> localTopics = new LinkedList<SIMPLocalTopicSpaceControllable>();
        SIMPIterator topics = this.getTopicSpaceIterator();
        while (topics.hasNext()) {
            SIMPTopicSpaceControllable topicSpace = (SIMPTopicSpaceControllable)topics.next();
            localTopics.add(topicSpace.getLocalTopicSpaceControl());
        }
        return new ControllableIterator(localTopics.iterator());
    }

    public SIMPIterator getRemoteTopicSpaceControllables() {
        LinkedList<Object> remoteTopics = new LinkedList<Object>();
        SIMPIterator topics = this.getTopicSpaceIterator();
        while (topics.hasNext()) {
            SIMPTopicSpaceControllable topicSpace = (SIMPTopicSpaceControllable)topics.next();
            SIMPIterator currentRemoteTopics = topicSpace.getRemoteTopicSpaceIterator();
            while (currentRemoteTopics.hasNext()) {
                remoteTopics.add(currentRemoteTopics.next());
            }
        }
        return new BasicSIMPIterator(remoteTopics.iterator());
    }

    public SIMPIterator getMQLinkIterator() {
        LinkTypeFilter filter = new LinkTypeFilter();
        filter.MQLINK = Boolean.TRUE;
        SIMPIterator linkItr = this.destinationManager.getLinkIndex().iterator(filter);
        return new ControllableIterator((Iterator)linkItr);
    }

    public SIMPVirtualLinkControllable getVirtualLinkByName(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVirtualLinkByName", (Object)new Object[]{name});
        }
        LinkHandler link = this.destinationManager.getLink(name);
        VirtualLinkControl control = (VirtualLinkControl)this.links.get(name);
        if (link != null) {
            VirtualLinkControl linkControl = (VirtualLinkControl)link.getControlAdapter();
            if (control != null) {
                linkControl.merge(control);
                this.links.remove(control);
            }
            control = linkControl;
        } else if (control == null) {
            control = new VirtualLinkControl(this.messageProcessor);
            this.links.put(name, control);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getVirtualLinkByName", (Object)control);
        }
        return control;
    }
}

