/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.am;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.processor.utils.am.GroupAlarmListener;
import com.ibm.ws.sib.processor.utils.am.MPAlarmImpl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedListEntry;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatchedTimeoutManager
implements GroupAlarmListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ObjectPool linkedListEntryPool;
    private SIBUuid12 uuid = new SIBUuid12();
    private long delta;
    private int numOfBuckets;
    private int percentLate;
    protected LinkedList activeEntries;
    private static final TraceComponent tc = SibTr.register(BatchedTimeoutManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MPAlarmManager am;
    private BatchedTimeoutProcessor handler;
    private ArrayList<BatchedTimeoutEntry> timedout;
    private boolean isStopped;
    private LockManager btmLockManager = new LockManager();
    private LockManager timeoutLockManager = new LockManager();
    private boolean batchFailed = false;
    private boolean batchCleared = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedTimeoutManager(int numOfBuckets, long timeoutInterval, List timeoutEntries, BatchedTimeoutProcessor handler, MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BatchedTimeoutManager", (Object)new Object[]{numOfBuckets, timeoutInterval, timeoutEntries, handler, messageProcessor});
        }
        this.btmLockManager.lockExclusive();
        try {
            this.am = messageProcessor.getAlarmManager();
            this.linkedListEntryPool = messageProcessor.getBatchedTimeoutManagerEntryPool();
            this.delta = timeoutInterval;
            this.numOfBuckets = numOfBuckets;
            long bucketInterval = this.delta / (long)(numOfBuckets - 1);
            this.percentLate = (int)(100L * bucketInterval / this.delta);
            this.timedout = new ArrayList(10);
            this.activeEntries = new LinkedList();
            this.isStopped = true;
            this.handler = handler;
            if (timeoutEntries != null) {
                Iterator itr = timeoutEntries.iterator();
                while (itr.hasNext()) {
                    this.addTimeoutEntry((BatchedTimeoutEntry)itr.next());
                }
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"BatchedTimeoutManager");
        }
    }

    public void updateTimeout(long newTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateTimeout", (Object)newTimeout);
        }
        this.delta = newTimeout;
        long bucketInterval = this.delta / (long)(this.numOfBuckets - 1);
        this.percentLate = (int)(100L * bucketInterval / this.delta);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateTimeout", (Object)this.percentLate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object context) {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)context);
            }
            this.btmLockManager.lock();
            boolean btmLocked = true;
            this.timeoutLockManager.lockExclusive();
            boolean timeoutLocked = true;
            try {
                if (this.timedout.isEmpty() || this.isStopped) break block12;
                this.btmLockManager.unlock();
                btmLocked = false;
                ArrayList<BatchedTimeoutEntry> tempTimeoutList = this.timedout;
                this.timedout = new ArrayList();
                this.timeoutLockManager.unlockExclusive();
                timeoutLocked = false;
                try {
                    this.handler.processTimedoutEntries(tempTimeoutList);
                    this.batchFailed = false;
                    this.batchCleared = false;
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager.alarm", (String)"1:280:1.24", (Object[])new Object[]{this, this.handler, tempTimeoutList});
                    SibTr.exception((TraceComponent)tc, (Throwable)e);
                    if (!this.batchFailed) {
                        this.batchFailed = true;
                    }
                    this.batchFailed = false;
                    for (BatchedTimeoutEntry bte : tempTimeoutList) {
                        this.removeTimeoutEntry(bte);
                    }
                    if (this.batchCleared) {
                        SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager.alarm", "1:325:1.24"}, null), e);
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager.alarm", (String)"1:331:1.24", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                        this.stopTimer();
                    }
                    this.batchCleared = true;
                }
                this.restartEntries(tempTimeoutList);
            }
            finally {
                if (timeoutLocked) {
                    this.timeoutLockManager.unlockExclusive();
                }
                if (btmLocked) {
                    this.btmLockManager.unlock();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    private void restartEntries(List timedout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restartEntries", (Object)new Object[]{timedout});
        }
        for (BatchedTimeoutEntry bte : timedout) {
            LinkedListEntry entry = bte.getEntry();
            if (entry == null || !this.activeEntries.contains(entry)) continue;
            this.startNewAlarm(entry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restartEntries");
        }
    }

    public void startTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startTimer");
        }
        this.btmLockManager.lockExclusive();
        try {
            if (this.isStopped) {
                this.isStopped = false;
                for (LinkedListEntry entry = (LinkedListEntry)this.activeEntries.getFirst(); entry != null && this.activeEntries.contains(entry); entry = (LinkedListEntry)entry.getNext()) {
                    this.startNewAlarm(entry);
                }
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startTimer");
        }
    }

    private void startNewAlarm(LinkedListEntry entry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewAlarm", (Object)new Object[]{entry});
        }
        entry.alarm = this.am.create(this.delta, this.percentLate, this, entry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewAlarm");
        }
    }

    public void stopTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopTimer");
        }
        this.btmLockManager.lockExclusive();
        try {
            if (!this.isStopped) {
                this.isStopped = true;
                for (LinkedListEntry entry = (LinkedListEntry)this.activeEntries.getFirst(); entry != null && this.activeEntries.contains(entry); entry = (LinkedListEntry)entry.getNext()) {
                    if (entry.alarm == null) continue;
                    entry.alarm.cancel();
                    entry.alarm = null;
                }
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopTimer");
        }
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        this.btmLockManager.lockExclusive();
        try {
            this.stopTimer();
            this.activeEntries = null;
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public void cancel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cancel");
        }
        ArrayList<BatchedTimeoutEntry> localActiveList = null;
        this.btmLockManager.lock();
        try {
            if (this.activeEntries != null) {
                for (LinkedListEntry entry = (LinkedListEntry)this.activeEntries.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                    if (entry.bte == null) continue;
                    if (localActiveList == null) {
                        localActiveList = new ArrayList<BatchedTimeoutEntry>();
                    }
                    localActiveList.add(entry.bte);
                }
            }
        }
        finally {
            this.btmLockManager.unlock();
        }
        if (localActiveList != null) {
            for (int i = 0; i < localActiveList.size(); ++i) {
                ((BatchedTimeoutEntry)localActiveList.get(i)).cancel();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancel");
        }
    }

    public void driveAllActiveEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"driveAllActiveEntries");
        }
        ArrayList<BatchedTimeoutEntry> localActiveList = null;
        this.btmLockManager.lock();
        try {
            for (LinkedListEntry entry = (LinkedListEntry)this.activeEntries.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                if (entry.bte == null) continue;
                if (localActiveList == null) {
                    localActiveList = new ArrayList<BatchedTimeoutEntry>();
                }
                localActiveList.add(entry.bte);
            }
        }
        finally {
            this.btmLockManager.unlock();
        }
        if (localActiveList != null) {
            this.handler.processTimedoutEntries(localActiveList);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"driveAllActiveEntries");
        }
    }

    public void addTimeoutEntry(BatchedTimeoutEntry bte) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTimeoutEntry", (Object)bte);
        }
        this.btmLockManager.lockExclusive();
        try {
            LinkedListEntry entry = (LinkedListEntry)this.linkedListEntryPool.remove();
            if (entry == null) {
                entry = new LinkedListEntry();
            }
            entry.bte = bte;
            bte.setEntry(entry);
            this.activeEntries.put(entry);
            if (!this.isStopped) {
                this.startNewAlarm(entry);
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTimeoutEntry");
        }
    }

    public void removeTimeoutEntry(BatchedTimeoutEntry bte) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTimeoutEntry", (Object)bte);
        }
        this.btmLockManager.lockExclusive();
        try {
            LinkedListEntry entry = bte.getEntry();
            if (this.activeEntries.contains(entry)) {
                this.activeEntries.remove(entry);
                bte.setEntry(null);
                if (entry.alarm != null) {
                    ((MPAlarmImpl)entry.alarm).cancelSingleEntry();
                    entry.alarm = null;
                }
                entry.bte = null;
                this.linkedListEntryPool.add((Object)entry);
            }
        }
        finally {
            this.btmLockManager.unlockExclusive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTimeoutEntry");
        }
    }

    @Override
    public void beginGroupAlarm(Object firstContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"beginGroupAlarm", (Object)new Object[]{firstContext});
        }
        LinkedListEntry entry = (LinkedListEntry)firstContext;
        this.btmLockManager.lock();
        this.timeoutLockManager.lockExclusive();
        try {
            if (!this.isStopped && this.activeEntries.contains(entry)) {
                this.timedout.clear();
                entry.alarm = null;
                this.timedout.add(entry.bte);
            }
        }
        finally {
            this.timeoutLockManager.unlockExclusive();
            this.btmLockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"beginGroupAlarm");
        }
    }

    @Override
    public void addContext(Object nextContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addContext", (Object)new Object[]{nextContext});
        }
        LinkedListEntry entry = (LinkedListEntry)nextContext;
        this.btmLockManager.lock();
        if (!this.isStopped && this.activeEntries.contains(entry)) {
            entry.alarm = null;
            this.timeoutLockManager.lockExclusive();
            this.timedout.add(entry.bte);
            this.timeoutLockManager.unlockExclusive();
        }
        this.btmLockManager.unlock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addContext");
        }
    }

    @Override
    public SIBUuid12 getGroupUuid() {
        return this.uuid;
    }

    public static class LinkedListEntry
    extends SimpleLinkedListEntry {
        Alarm alarm;
        public BatchedTimeoutEntry bte;

        @Override
        public synchronized String toString(String indent) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(indent);
            buffer.append("LinkedListEntry(" + this.bte + ",");
            if (this.parentList == null) {
                buffer.append(" not in list)");
            } else {
                buffer.append("\n" + indent + indent + "\\->" + this.alarm + ")");
            }
            return buffer.toString();
        }
    }
}

