/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Entry {
    protected LinkedList parentList = null;
    protected Entry previous = null;
    protected Entry next = null;
    protected Cursor firstCursor = null;
    private static final TraceComponent tc = SibTr.register(Entry.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public Entry getPrevious() {
        this.checkEntryParent();
        Entry entry = null;
        if (!this.isFirst()) {
            entry = this.previous;
        }
        return entry;
    }

    public Entry getNext() {
        Entry entry = null;
        if (!this.isLast()) {
            entry = this.next;
        }
        return entry;
    }

    Entry forceInsertAfter(Entry newEntry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceInsertAfter", (Object)new Object[]{newEntry});
        }
        this.checkEntryParent();
        if (newEntry.parentList == null) {
            Entry nextEntry = this.getNext();
            newEntry.previous = this;
            newEntry.next = nextEntry;
            newEntry.parentList = this.parentList;
            if (nextEntry != null) {
                nextEntry.previous = newEntry;
            }
            this.next = newEntry;
            if (this.isLast()) {
                this.parentList.last = newEntry;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceInsertAfter", (Object)newEntry);
            }
            return newEntry;
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:164:1.17"}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Entry.forceInsertAfter", (String)"1:170:1.17", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:177:1.17"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceInsertAfter", (Object)((Object)e));
        }
        throw e;
    }

    Entry forceRemove() {
        Entry nextEntry;
        Entry prevEntry;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceRemove");
        }
        this.checkEntryParent();
        Entry removedEntry = null;
        if (this.firstCursor != null) {
            Cursor cursor = this.firstCursor;
            while (cursor != null) {
                cursor.previous();
                cursor = this.firstCursor;
            }
        }
        if ((prevEntry = this.getPrevious()) != null) {
            prevEntry.next = this.next;
        }
        if ((nextEntry = this.getNext()) != null) {
            nextEntry.previous = prevEntry;
        }
        if (this.isFirst()) {
            this.parentList.first = nextEntry;
        }
        if (this.isLast()) {
            this.parentList.last = prevEntry;
        }
        this.next = null;
        this.previous = null;
        this.parentList = null;
        removedEntry = this;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceRemove", (Object)removedEntry);
        }
        return removedEntry;
    }

    void checkEntryParent() {
        if (this.parentList == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:261:1.17"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Entry.checkEntryParent", (String)"1:268:1.17", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:275:1.17"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkEntryParent", (Object)((Object)e));
            }
            throw e;
        }
    }

    boolean isFirst() {
        return this.parentList.first == this;
    }

    boolean isLast() {
        return this.parentList.last == this;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer buffer = new StringBuffer();
        if (this.parentList == null) {
            buffer.append("Entry not in list");
        } else {
            buffer.append(indent);
            buffer.append(super.toString());
            Cursor cursor = this.firstCursor;
            while (cursor != null) {
                buffer.append("\n");
                buffer.append(indent);
                buffer.append("\\-->");
                buffer.append(cursor);
                cursor = (Cursor)cursor.next;
            }
        }
        return buffer.toString();
    }
}

