/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SoapMessage
extends MessageImpl {
    private static final long serialVersionUID = 6310906412722265578L;
    private SoapVersion version;
    private static final Logger LOG = LogUtils.getL7dLogger(SoapMessage.class);

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapMessage(Message message) {
        super(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "<init>", new Object[]{message});
        }
        this.setVersion(Soap11.getInstance());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapMessage(SoapVersion ver) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "<init>", new Object[]{ver});
        }
        this.setVersion(ver);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapVersion getVersion() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "getVersion", new Object[0]);
        }
        SoapVersion soapVersion = this.version;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapVersion = soapVersion;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "getVersion", soapVersion);
        }
        return soapVersion;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void setVersion(SoapVersion v) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "setVersion", new Object[]{v});
        }
        super.put(SoapVersion.class, (Object)v);
        this.version = v;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "setVersion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Header> getHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "getHeaders", new Object[0]);
        }
        ArrayList<Header> heads = CastUtils.cast((List)((List)this.get(Header.HEADER_LIST)));
        if (heads == null) {
            heads = new ArrayList<Header>();
            this.put(Header.HEADER_LIST, heads);
        }
        ArrayList<Header> arrayList = heads;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "getHeaders", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasHeader(QName qn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "hasHeader", new Object[]{qn});
        }
        for (Header head : this.getHeaders()) {
            if (!head.getName().equals(qn)) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "hasHeader", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "hasHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Header getHeader(QName qn) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "getHeader", new Object[]{qn});
        }
        for (Header head : this.getHeaders()) {
            if (!head.getName().equals(qn)) continue;
            Header header = head;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                header = header;
                LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "getHeader", header);
            }
            return header;
        }
        Header header = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            header = header;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "getHeader", header);
        }
        return header;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "hasHeaders", new Object[0]);
        }
        boolean bl = this.containsKey(Header.HEADER_LIST) && !this.getHeaders().isEmpty();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "hasHeaders", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> getEnvelopeNs() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "getEnvelopeNs", new Object[0]);
        }
        Map map = CastUtils.cast((Map)((Map)this.getContextualProperty("soap.env.ns.map")));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "getEnvelopeNs", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasAdditionalEnvNs() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.SoapMessage", "hasAdditionalEnvNs", new Object[0]);
        }
        Map<String, String> ns = this.getEnvelopeNs();
        boolean bl = ns != null && !ns.isEmpty();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.binding.soap.SoapMessage", "hasAdditionalEnvNs", bl);
        }
        return bl;
    }
}

